/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.schema.validator;

import java.util.EnumMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.AvroSchemaValidator;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.JsonSchemaValidator;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidator;

@Component
public class SchemaValidatorProvider {
    private final Map<Topic.ContentType, SchemaValidator> validators = new EnumMap<Topic.ContentType, SchemaValidator>(Topic.ContentType.class);

    @Autowired
    public SchemaValidatorProvider(JsonSchemaValidator jsonSchemaValidator, AvroSchemaValidator avroSchemaValidator) {
        this.validators.put(Topic.ContentType.AVRO, avroSchemaValidator);
        this.validators.put(Topic.ContentType.JSON, jsonSchemaValidator);
    }

    public SchemaValidator provide(Topic.ContentType contentType) {
        return this.validators.get(contentType);
    }
}

