/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.AbstractSubscriptionHealthProblemIndicator;

public class SlowIndicator
extends AbstractSubscriptionHealthProblemIndicator {
    private final double minSubscriptionToTopicSpeedRatio;

    public SlowIndicator(double minSubscriptionToTopicSpeedRatio) {
        this.minSubscriptionToTopicSpeedRatio = minSubscriptionToTopicSpeedRatio;
    }

    @Override
    public boolean problemOccurs(SubscriptionHealthContext context) {
        double topicRate;
        double subscriptionRate = context.getSubscriptionMetrics().getRate();
        return subscriptionRate < this.minSubscriptionToTopicSpeedRatio * (topicRate = context.getTopicMetrics().getRate());
    }

    @Override
    public SubscriptionHealth.Problem getProblem() {
        return SubscriptionHealth.Problem.SLOW;
    }
}

