/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Anonymizable;
import pl.allegro.tech.hermes.api.MessageTrace;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.api.SubscriptionMetrics;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.SubscriptionNameWithMetrics;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.api.UnhealthySubscription;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.management.domain.Auditor;
import pl.allegro.tech.hermes.management.domain.subscription.CreatorRights;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionMetricsRepository;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionOwnerCache;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthChecker;
import pl.allegro.tech.hermes.management.domain.subscription.validator.SubscriptionValidator;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.tracker.management.LogRepository;

@Component
public class SubscriptionService {
    private static final int LAST_MESSAGE_COUNT = 100;
    private final SubscriptionRepository subscriptionRepository;
    private final SubscriptionOwnerCache subscriptionOwnerCache;
    private final TopicService topicService;
    private final SubscriptionMetricsRepository metricsRepository;
    private final SubscriptionHealthChecker subscriptionHealthChecker;
    private final UndeliveredMessageLog undeliveredMessageLog;
    private final LogRepository logRepository;
    private final SubscriptionValidator subscriptionValidator;
    private final Auditor auditor;

    @Autowired
    public SubscriptionService(SubscriptionRepository subscriptionRepository, SubscriptionOwnerCache subscriptionOwnerCache, TopicService topicService, SubscriptionMetricsRepository metricsRepository, SubscriptionHealthChecker subscriptionHealthChecker, UndeliveredMessageLog undeliveredMessageLog, LogRepository logRepository, SubscriptionValidator subscriptionValidator, Auditor auditor) {
        this.subscriptionRepository = subscriptionRepository;
        this.subscriptionOwnerCache = subscriptionOwnerCache;
        this.topicService = topicService;
        this.metricsRepository = metricsRepository;
        this.subscriptionHealthChecker = subscriptionHealthChecker;
        this.undeliveredMessageLog = undeliveredMessageLog;
        this.logRepository = logRepository;
        this.subscriptionValidator = subscriptionValidator;
        this.auditor = auditor;
    }

    public List<String> listSubscriptionNames(TopicName topicName) {
        return this.subscriptionRepository.listSubscriptionNames(topicName);
    }

    public List<String> listTrackedSubscriptionNames(TopicName topicName) {
        return this.listSubscriptions(topicName).stream().filter(Subscription::isTrackingEnabled).map(Subscription::getName).collect(Collectors.toList());
    }

    public List<String> listFilteredSubscriptionNames(TopicName topicName, Query<Subscription> query) {
        return query.filter(this.listSubscriptions(topicName)).map(Subscription::getName).collect(Collectors.toList());
    }

    public List<Subscription> listSubscriptions(TopicName topicName) {
        return this.subscriptionRepository.listSubscriptions(topicName);
    }

    public void createSubscription(Subscription subscription, String createdBy, CreatorRights creatorRights) {
        this.subscriptionValidator.checkCreation(subscription, creatorRights);
        this.subscriptionRepository.createSubscription(subscription);
        this.auditor.objectCreated(createdBy, (Anonymizable)subscription);
        this.subscriptionOwnerCache.onCreatedSubscription(subscription);
    }

    public Subscription getSubscriptionDetails(TopicName topicName, String subscriptionName) {
        return this.subscriptionRepository.getSubscriptionDetails(topicName, subscriptionName).anonymize();
    }

    public void removeSubscription(TopicName topicName, String subscriptionName, String removedBy) {
        this.subscriptionRepository.removeSubscription(topicName, subscriptionName);
        this.auditor.objectRemoved(removedBy, Subscription.class.getSimpleName(), subscriptionName);
        this.subscriptionOwnerCache.onRemovedSubscription(subscriptionName, topicName);
    }

    public void updateSubscription(TopicName topicName, String subscriptionName, PatchData patch, String modifiedBy) {
        Subscription retrieved = this.subscriptionRepository.getSubscriptionDetails(topicName, subscriptionName);
        Subscription.State oldState = retrieved.getState();
        Subscription updated = (Subscription)Patch.apply((Object)retrieved, (PatchData)patch);
        this.revertStateIfChangedToPending(updated, oldState);
        this.subscriptionValidator.checkModification(updated);
        this.subscriptionOwnerCache.onUpdatedSubscription(retrieved, updated);
        if (!retrieved.equals((Object)updated)) {
            this.subscriptionRepository.updateSubscription(updated);
            this.auditor.objectUpdated(modifiedBy, (Anonymizable)retrieved, (Anonymizable)updated);
        }
    }

    private void revertStateIfChangedToPending(Subscription updated, Subscription.State oldState) {
        if (updated.getState() == Subscription.State.PENDING) {
            updated.setState(oldState);
        }
    }

    public void updateSubscriptionState(TopicName topicName, String subscriptionName, Subscription.State state, String modifiedBy) {
        Subscription retrieved = this.subscriptionRepository.getSubscriptionDetails(topicName, subscriptionName);
        if (state != Subscription.State.PENDING && !retrieved.getState().equals((Object)state)) {
            Subscription updated = (Subscription)Patch.apply((Object)retrieved, (PatchData)PatchData.patchData().set("state", (Object)state).build());
            this.subscriptionRepository.updateSubscription(updated);
            this.auditor.objectUpdated(modifiedBy, (Anonymizable)retrieved, (Anonymizable)updated);
        }
    }

    public Subscription.State getSubscriptionState(TopicName topicName, String subscriptionName) {
        return this.getSubscriptionDetails(topicName, subscriptionName).getState();
    }

    public SubscriptionMetrics getSubscriptionMetrics(TopicName topicName, String subscriptionName) {
        this.subscriptionRepository.ensureSubscriptionExists(topicName, subscriptionName);
        return this.metricsRepository.loadMetrics(topicName, subscriptionName);
    }

    public SubscriptionHealth getSubscriptionHealth(TopicName topicName, String subscriptionName) {
        Subscription subscription = this.getSubscriptionDetails(topicName, subscriptionName);
        return this.getHealth(subscription);
    }

    public Optional<SentMessageTrace> getLatestUndeliveredMessage(TopicName topicName, String subscriptionName) {
        return this.undeliveredMessageLog.last(topicName, subscriptionName);
    }

    public List<SentMessageTrace> getLatestUndeliveredMessagesTrackerLogs(TopicName topicName, String subscriptionName) {
        return this.logRepository.getLastUndeliveredMessages(topicName.qualifiedName(), subscriptionName, 100);
    }

    public List<MessageTrace> getMessageStatus(String qualifiedTopicName, String subscriptionName, String messageId) {
        return this.logRepository.getMessageStatus(qualifiedTopicName, subscriptionName, messageId);
    }

    public List<Subscription> querySubscription(Query<Subscription> query) {
        return query.filter(this.getAllSubscriptions()).collect(Collectors.toList());
    }

    public List<SubscriptionNameWithMetrics> querySubscriptionsMetrics(Query<SubscriptionNameWithMetrics> query) {
        List<SubscriptionNameWithMetrics> allMetrics = this.getSubscriptionsMetrics();
        Stream<SubscriptionNameWithMetrics> availableMetrics = allMetrics.stream().filter(SubscriptionNameWithMetrics::allMetricsAreAvailable);
        Stream<SubscriptionNameWithMetrics> unavailableMetrics = allMetrics.stream().filter(metrics -> !metrics.allMetricsAreAvailable());
        return Stream.concat(query.filter(availableMetrics), unavailableMetrics).collect(Collectors.toList());
    }

    public List<Subscription> getAllSubscriptions() {
        return this.topicService.getAllTopics().stream().map(Topic::getName).map(this::listSubscriptions).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Subscription> getForOwnerId(OwnerId ownerId) {
        Collection<SubscriptionName> subscriptionNames = this.subscriptionOwnerCache.get(ownerId);
        return this.subscriptionRepository.getSubscriptionDetails(subscriptionNames);
    }

    public List<UnhealthySubscription> getAllUnhealthy(boolean respectMonitoringSeverity) {
        Collection<SubscriptionName> subscriptionNames = this.subscriptionOwnerCache.getAll();
        List subscriptions = this.subscriptionRepository.getSubscriptionDetails(subscriptionNames);
        return this.filterHealthy(subscriptions, respectMonitoringSeverity);
    }

    public List<UnhealthySubscription> getUnhealthyForOwner(OwnerId ownerId, boolean respectMonitoringSeverity) {
        List<Subscription> ownerSubscriptions = this.getForOwnerId(ownerId);
        return this.filterHealthy(ownerSubscriptions, respectMonitoringSeverity);
    }

    private List<UnhealthySubscription> filterHealthy(Collection<Subscription> subscriptions, boolean respectMonitoringSeverity) {
        return subscriptions.stream().filter(s -> this.filterBySeverityMonitorFlag(respectMonitoringSeverity, s.isSeverityNotImportant())).flatMap(s -> {
            SubscriptionHealth subscriptionHealth = this.getHealth((Subscription)s);
            if (subscriptionHealth.getStatus() == SubscriptionHealth.Status.UNHEALTHY) {
                return Stream.of(UnhealthySubscription.from((Subscription)s, (SubscriptionHealth)subscriptionHealth));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private boolean filterBySeverityMonitorFlag(boolean respectMonitoringSeverity, boolean isSeverityNotImportant) {
        return !respectMonitoringSeverity || !isSeverityNotImportant;
    }

    private SubscriptionHealth getHealth(Subscription subscription) {
        TopicName topicName = subscription.getTopicName();
        TopicMetrics topicMetrics = this.topicService.getTopicMetrics(topicName);
        SubscriptionMetrics subscriptionMetrics = this.getSubscriptionMetrics(topicName, subscription.getName());
        return this.subscriptionHealthChecker.checkHealth(subscription, topicMetrics, subscriptionMetrics);
    }

    private List<SubscriptionNameWithMetrics> getSubscriptionsMetrics() {
        return this.getAllSubscriptions().stream().map(s -> {
            SubscriptionMetrics metrics = this.metricsRepository.loadMetrics(s.getTopicName(), s.getName());
            return SubscriptionNameWithMetrics.from((SubscriptionMetrics)metrics, (String)s.getName(), (String)s.getQualifiedTopicName());
        }).collect(Collectors.toList());
    }
}

