/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.matcher;

import org.apache.commons.jxpath.JXPathException;
import pl.allegro.tech.hermes.management.infrastructure.query.graph.ObjectGraph;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.ComparisonOperator;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherException;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherInputException;

public class ComparisonMatcher
implements Matcher {
    private final String attribute;
    private final Object rightSideValue;
    private final ComparisonOperator operator;

    public ComparisonMatcher(String attribute, Object rightSideValue, ComparisonOperator operator) {
        this.attribute = attribute;
        this.rightSideValue = rightSideValue;
        this.operator = operator;
    }

    @Override
    public boolean match(Object value) {
        Object leftSideValue = this.getUserInput(value);
        double leftSideValueAsNumber = this.parseToNumber(leftSideValue);
        double rightSideValueAsNumber = this.parseToNumber(this.rightSideValue);
        return this.makeComparison(leftSideValueAsNumber, rightSideValueAsNumber);
    }

    private Object getUserInput(Object value) {
        try {
            Object userInput = ObjectGraph.from(value).navigate(this.attribute).value();
            if (userInput == null) {
                throw new MatcherInputException(String.format("Cannot find '%s' attribute", this.attribute));
            }
            return userInput;
        }
        catch (JXPathException e) {
            throw new MatcherException(String.format("Could not navigate to specific path: '%s'", this.attribute), e);
        }
    }

    private Double parseToNumber(Object value) {
        try {
            return Double.parseDouble(this.asString(value));
        }
        catch (NumberFormatException e) {
            throw new MatcherInputException("Comparison operator requires numerical data");
        }
    }

    private boolean makeComparison(Double leftSideNumber, Double rightSideNumber) {
        return this.operator.compare(leftSideNumber, rightSideNumber);
    }

    private String asString(Object value) {
        return String.valueOf(value);
    }
}

