/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.management.domain.mode.ModeService;

@Provider
@Priority(value=2001)
public class ReadOnlyFilter
implements ContainerRequestFilter {
    private static final String READ_ONLY_ERROR_MESSAGE = "Action forbidden due to read-only mode";
    private final ModeService modeService;

    @Autowired
    public ReadOnlyFilter(ModeService modeService) {
        this.modeService = modeService;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ContainerRequest req;
        if (this.modeService.isReadOnlyEnabled() && !this.isWhitelisted(req = (ContainerRequest)requestContext.getRequest()) && !this.isAdmin(requestContext)) {
            throw new ServiceUnavailableException(READ_ONLY_ERROR_MESSAGE);
        }
    }

    private boolean isAdmin(ContainerRequestContext requestContext) {
        return requestContext.getSecurityContext().isUserInRole("admin");
    }

    private boolean isWhitelisted(ContainerRequest req) {
        if (req.getMethod().equals("GET")) {
            return true;
        }
        String requestURI = req.getUriInfo().getPath();
        if (requestURI.startsWith("/query")) {
            return true;
        }
        if (requestURI.startsWith("/mode")) {
            return true;
        }
        return requestURI.startsWith("/topics") && requestURI.endsWith("query");
    }
}

