/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.auth;

import javax.ws.rs.container.ContainerRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Group;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.api.auth.CreatorRights;
import pl.allegro.tech.hermes.management.api.auth.SecurityProvider;
import pl.allegro.tech.hermes.management.config.GroupProperties;

@Component
public class ManagementRights {
    private final TopicRepository topicRepository;
    private final GroupProperties groupProperties;

    @Autowired
    public ManagementRights(TopicRepository topicRepository, GroupProperties groupProperties) {
        this.topicRepository = topicRepository;
        this.groupProperties = groupProperties;
    }

    public boolean isUserAllowedToManageTopic(Topic topic, ContainerRequestContext requestContext) {
        return this.isAdmin(requestContext) || this.getOwnershipResolver(requestContext).isUserAnOwner(topic.getOwner());
    }

    public boolean isUserAllowedToCreateSubscription(Subscription subscription, ContainerRequestContext requestContext) {
        return !this.topicRepository.isSubscribingRestricted(subscription.getTopicName()) || this.isAdmin(requestContext);
    }

    public boolean isUserAllowedToCreateGroup(ContainerRequestContext requestContext) {
        return this.isAdmin(requestContext) || this.groupProperties.isNonAdminCreationEnabled();
    }

    private boolean isUserAllowedToManageGroup(ContainerRequestContext requestContext) {
        return this.isAdmin(requestContext);
    }

    public boolean isUserAllowedToManageSubscription(Subscription subscription, ContainerRequestContext requestContext) {
        return this.isAdmin(requestContext) || this.isSubscriptionOwner(subscription, requestContext);
    }

    private boolean isSubscriptionOwner(Subscription subscription, ContainerRequestContext requestContext) {
        return this.getOwnershipResolver(requestContext).isUserAnOwner(subscription.getOwner());
    }

    private boolean isAdmin(ContainerRequestContext requestContext) {
        return requestContext.getSecurityContext().isUserInRole("admin");
    }

    private SecurityProvider.OwnershipResolver getOwnershipResolver(ContainerRequestContext requestContext) {
        return (SecurityProvider.OwnershipResolver)requestContext.getProperty("ownership-resolver");
    }

    public CreatorRights<Subscription> getSubscriptionCreatorRights(ContainerRequestContext requestContext) {
        return new SubscriptionCreatorRights(requestContext);
    }

    public CreatorRights<Group> getGroupCreatorRights(ContainerRequestContext requestContext) {
        return new GroupCreatorRights(requestContext);
    }

    class GroupCreatorRights
    implements CreatorRights<Group> {
        private ContainerRequestContext requestContext;

        GroupCreatorRights(ContainerRequestContext requestContext) {
            this.requestContext = requestContext;
        }

        @Override
        public boolean allowedToManage(Group group) {
            return ManagementRights.this.isUserAllowedToManageGroup(this.requestContext);
        }

        @Override
        public boolean allowedToCreate(Group group) {
            return ManagementRights.this.isUserAllowedToCreateGroup(this.requestContext);
        }
    }

    class SubscriptionCreatorRights
    implements CreatorRights<Subscription> {
        private ContainerRequestContext requestContext;

        SubscriptionCreatorRights(ContainerRequestContext requestContext) {
            this.requestContext = requestContext;
        }

        @Override
        public boolean allowedToManage(Subscription subscription) {
            return ManagementRights.this.isUserAllowedToManageSubscription(subscription, this.requestContext);
        }

        @Override
        public boolean allowedToCreate(Subscription subscription) {
            return ManagementRights.this.isUserAllowedToCreateSubscription(subscription, this.requestContext);
        }
    }
}

