/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.metrics;

import com.google.common.primitives.Longs;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummedDistributedEphemeralCounter {
    private static final Logger logger = LoggerFactory.getLogger(SummedDistributedEphemeralCounter.class);
    private final List<CuratorFramework> curatorClients;

    public SummedDistributedEphemeralCounter(List<CuratorFramework> curatorClients) {
        this.curatorClients = curatorClients;
    }

    public long getValue(String basePath, String childrenPath) {
        return this.curatorClients.stream().map(client -> this.getValue((CuratorFramework)client, basePath, childrenPath)).reduce(0L, (a, b) -> a + b);
    }

    private long getValue(CuratorFramework curatorClient, String basePath, String childrenPath) {
        try {
            return ((List)curatorClient.getChildren().forPath(basePath)).stream().map(child -> this.getValueForChild(curatorClient, basePath, childrenPath, (String)child)).reduce(0L, (a, b) -> a + b);
        }
        catch (Exception e) {
            logger.warn("Error while reading value for base path: {} and child path: {}; {}", new Object[]{basePath, childrenPath, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return 0L;
        }
    }

    private long getValueForChild(CuratorFramework curatorClient, String basePath, String childrenPath, String child) {
        try {
            return Longs.fromByteArray((byte[])((byte[])curatorClient.getData().forPath(basePath + "/" + child + childrenPath)));
        }
        catch (KeeperException.NoNodeException e) {
            logger.trace("Someone removed node " + basePath + "/" + child + childrenPath + " while we were iterating", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Error while reading value for base path: {} and child path: {}; {}", new Object[]{basePath, childrenPath, ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
        return 0L;
    }
}

