/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Anonymizable;
import pl.allegro.tech.hermes.api.MessageTrace;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.api.SubscriptionMetrics;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.SubscriptionNameWithMetrics;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.api.UnhealthySubscription;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.management.domain.Auditor;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryCommandExecutor;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryManager;
import pl.allegro.tech.hermes.management.domain.subscription.CreatorRights;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionMetricsRepository;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionOwnerCache;
import pl.allegro.tech.hermes.management.domain.subscription.commands.CreateSubscriptionRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.subscription.commands.RemoveSubscriptionRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.subscription.commands.UpdateSubscriptionRepositoryCommand;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthChecker;
import pl.allegro.tech.hermes.management.domain.subscription.validator.SubscriptionValidator;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.tracker.management.LogRepository;

@Component
public class SubscriptionService {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionService.class);
    private static final int LAST_MESSAGE_COUNT = 100;
    private final SubscriptionRepository subscriptionRepository;
    private final SubscriptionOwnerCache subscriptionOwnerCache;
    private final TopicService topicService;
    private final SubscriptionMetricsRepository metricsRepository;
    private final SubscriptionHealthChecker subscriptionHealthChecker;
    private final LogRepository logRepository;
    private final SubscriptionValidator subscriptionValidator;
    private final Auditor auditor;
    private final MultiDatacenterRepositoryCommandExecutor multiDcExecutor;
    private final RepositoryManager repositoryManager;

    @Autowired
    public SubscriptionService(SubscriptionRepository subscriptionRepository, SubscriptionOwnerCache subscriptionOwnerCache, TopicService topicService, SubscriptionMetricsRepository metricsRepository, SubscriptionHealthChecker subscriptionHealthChecker, LogRepository logRepository, SubscriptionValidator subscriptionValidator, Auditor auditor, MultiDatacenterRepositoryCommandExecutor multiDcExecutor, RepositoryManager repositoryManager) {
        this.subscriptionRepository = subscriptionRepository;
        this.subscriptionOwnerCache = subscriptionOwnerCache;
        this.topicService = topicService;
        this.metricsRepository = metricsRepository;
        this.subscriptionHealthChecker = subscriptionHealthChecker;
        this.logRepository = logRepository;
        this.subscriptionValidator = subscriptionValidator;
        this.auditor = auditor;
        this.multiDcExecutor = multiDcExecutor;
        this.repositoryManager = repositoryManager;
    }

    public List<String> listSubscriptionNames(TopicName topicName) {
        return this.subscriptionRepository.listSubscriptionNames(topicName);
    }

    public List<String> listTrackedSubscriptionNames(TopicName topicName) {
        return this.listSubscriptions(topicName).stream().filter(Subscription::isTrackingEnabled).map(Subscription::getName).collect(Collectors.toList());
    }

    public List<String> listFilteredSubscriptionNames(TopicName topicName, Query<Subscription> query) {
        return query.filter(this.listSubscriptions(topicName)).map(Subscription::getName).collect(Collectors.toList());
    }

    public List<Subscription> listSubscriptions(TopicName topicName) {
        return this.subscriptionRepository.listSubscriptions(topicName);
    }

    public void createSubscription(Subscription subscription, String createdBy, CreatorRights creatorRights) {
        this.subscriptionValidator.checkCreation(subscription, creatorRights);
        this.multiDcExecutor.execute(new CreateSubscriptionRepositoryCommand(subscription));
        this.auditor.objectCreated(createdBy, (Anonymizable)subscription);
        this.subscriptionOwnerCache.onCreatedSubscription(subscription);
    }

    public Subscription getSubscriptionDetails(TopicName topicName, String subscriptionName) {
        Subscription subscription = this.subscriptionRepository.getSubscriptionDetails(topicName, subscriptionName).anonymize();
        subscription.setState(this.getEffectiveState(topicName, subscriptionName));
        return subscription;
    }

    private Subscription.State getEffectiveState(TopicName topicName, String subscriptionName) {
        Set<Subscription.State> states = this.loadSubscriptionStatesFromAllDc(topicName, subscriptionName);
        if (states.size() > 1) {
            logger.warn("Some states are out of sync: {}", states);
        }
        if (states.contains(Subscription.State.ACTIVE)) {
            return Subscription.State.ACTIVE;
        }
        if (states.contains(Subscription.State.SUSPENDED)) {
            return Subscription.State.SUSPENDED;
        }
        return Subscription.State.PENDING;
    }

    private Set<Subscription.State> loadSubscriptionStatesFromAllDc(TopicName topicName, String subscriptionName) {
        List<DatacenterBoundRepositoryHolder<SubscriptionRepository>> holders = this.repositoryManager.getRepositories(SubscriptionRepository.class);
        HashSet<Subscription.State> states = new HashSet<Subscription.State>();
        for (DatacenterBoundRepositoryHolder<SubscriptionRepository> holder : holders) {
            try {
                Subscription.State state = holder.getRepository().getSubscriptionDetails(topicName, subscriptionName).getState();
                states.add(state);
            }
            catch (Exception e) {
                logger.warn("Could not load state of subscription (topic: {}, name: {}) from DC {}.", new Object[]{topicName, subscriptionName, holder.getDatacenterName()});
            }
        }
        return states;
    }

    public void removeSubscription(TopicName topicName, String subscriptionName, String removedBy) {
        this.multiDcExecutor.execute(new RemoveSubscriptionRepositoryCommand(topicName, subscriptionName));
        this.auditor.objectRemoved(removedBy, Subscription.class.getSimpleName(), subscriptionName);
        this.subscriptionOwnerCache.onRemovedSubscription(subscriptionName, topicName);
    }

    public void updateSubscription(TopicName topicName, String subscriptionName, PatchData patch, String modifiedBy) {
        Subscription retrieved = this.subscriptionRepository.getSubscriptionDetails(topicName, subscriptionName);
        Subscription.State oldState = retrieved.getState();
        Subscription updated = (Subscription)Patch.apply((Object)retrieved, (PatchData)patch);
        this.revertStateIfChangedToPending(updated, oldState);
        this.subscriptionValidator.checkModification(updated);
        this.subscriptionOwnerCache.onUpdatedSubscription(retrieved, updated);
        if (!retrieved.equals((Object)updated)) {
            this.multiDcExecutor.execute(new UpdateSubscriptionRepositoryCommand(updated));
            this.auditor.objectUpdated(modifiedBy, (Anonymizable)retrieved, (Anonymizable)updated);
        }
    }

    private void revertStateIfChangedToPending(Subscription updated, Subscription.State oldState) {
        if (updated.getState() == Subscription.State.PENDING) {
            updated.setState(oldState);
        }
    }

    public void updateSubscriptionState(TopicName topicName, String subscriptionName, Subscription.State state, String modifiedBy) {
        Subscription retrieved = this.subscriptionRepository.getSubscriptionDetails(topicName, subscriptionName);
        if (state != Subscription.State.PENDING && !retrieved.getState().equals((Object)state)) {
            Subscription updated = (Subscription)Patch.apply((Object)retrieved, (PatchData)PatchData.patchData().set("state", (Object)state).build());
            this.multiDcExecutor.execute(new UpdateSubscriptionRepositoryCommand(updated));
            this.auditor.objectUpdated(modifiedBy, (Anonymizable)retrieved, (Anonymizable)updated);
        }
    }

    public Subscription.State getSubscriptionState(TopicName topicName, String subscriptionName) {
        return this.getSubscriptionDetails(topicName, subscriptionName).getState();
    }

    public SubscriptionMetrics getSubscriptionMetrics(TopicName topicName, String subscriptionName) {
        this.subscriptionRepository.ensureSubscriptionExists(topicName, subscriptionName);
        return this.metricsRepository.loadMetrics(topicName, subscriptionName);
    }

    public SubscriptionHealth getSubscriptionHealth(TopicName topicName, String subscriptionName) {
        Subscription subscription = this.getSubscriptionDetails(topicName, subscriptionName);
        return this.getHealth(subscription);
    }

    public Optional<SentMessageTrace> getLatestUndeliveredMessage(TopicName topicName, String subscriptionName) {
        List<DatacenterBoundRepositoryHolder<UndeliveredMessageLog>> holders = this.repositoryManager.getRepositories(UndeliveredMessageLog.class);
        ArrayList traces = new ArrayList();
        for (DatacenterBoundRepositoryHolder<UndeliveredMessageLog> holder : holders) {
            try {
                holder.getRepository().last(topicName, subscriptionName).ifPresent(traces::add);
            }
            catch (Exception e) {
                logger.warn("Could not load latest undelivered message from DC: {}", (Object)holder.getDatacenterName());
            }
        }
        return traces.stream().max(Comparator.comparing(SentMessageTrace::getTimestamp));
    }

    public List<SentMessageTrace> getLatestUndeliveredMessagesTrackerLogs(TopicName topicName, String subscriptionName) {
        return this.logRepository.getLastUndeliveredMessages(topicName.qualifiedName(), subscriptionName, 100);
    }

    public List<MessageTrace> getMessageStatus(String qualifiedTopicName, String subscriptionName, String messageId) {
        return this.logRepository.getMessageStatus(qualifiedTopicName, subscriptionName, messageId);
    }

    public List<Subscription> querySubscription(Query<Subscription> query) {
        return query.filter(this.getAllSubscriptions()).collect(Collectors.toList());
    }

    public List<SubscriptionNameWithMetrics> querySubscriptionsMetrics(Query<SubscriptionNameWithMetrics> query) {
        return query.filter(this.getSubscriptionsMetrics()).collect(Collectors.toList());
    }

    public List<Subscription> getAllSubscriptions() {
        return this.topicService.getAllTopics().stream().map(Topic::getName).map(this::listSubscriptions).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Subscription> getForOwnerId(OwnerId ownerId) {
        Collection<SubscriptionName> subscriptionNames = this.subscriptionOwnerCache.get(ownerId);
        return this.subscriptionRepository.getSubscriptionDetails(subscriptionNames);
    }

    public List<UnhealthySubscription> getAllUnhealthy(boolean respectMonitoringSeverity) {
        Collection<SubscriptionName> subscriptionNames = this.subscriptionOwnerCache.getAll();
        List subscriptions = this.subscriptionRepository.getSubscriptionDetails(subscriptionNames);
        return this.filterHealthy(subscriptions, respectMonitoringSeverity);
    }

    public List<UnhealthySubscription> getUnhealthyForOwner(OwnerId ownerId, boolean respectMonitoringSeverity) {
        List<Subscription> ownerSubscriptions = this.getForOwnerId(ownerId);
        return this.filterHealthy(ownerSubscriptions, respectMonitoringSeverity);
    }

    private List<UnhealthySubscription> filterHealthy(Collection<Subscription> subscriptions, boolean respectMonitoringSeverity) {
        return subscriptions.stream().filter(s -> this.filterBySeverityMonitorFlag(respectMonitoringSeverity, s.isSeverityNotImportant())).flatMap(s -> {
            SubscriptionHealth subscriptionHealth = this.getHealth((Subscription)s);
            if (subscriptionHealth.getStatus() == SubscriptionHealth.Status.UNHEALTHY) {
                return Stream.of(UnhealthySubscription.from((Subscription)s, (SubscriptionHealth)subscriptionHealth));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private boolean filterBySeverityMonitorFlag(boolean respectMonitoringSeverity, boolean isSeverityNotImportant) {
        return !respectMonitoringSeverity || !isSeverityNotImportant;
    }

    private SubscriptionHealth getHealth(Subscription subscription) {
        TopicName topicName = subscription.getTopicName();
        TopicMetrics topicMetrics = this.topicService.getTopicMetrics(topicName);
        SubscriptionMetrics subscriptionMetrics = this.getSubscriptionMetrics(topicName, subscription.getName());
        return this.subscriptionHealthChecker.checkHealth(subscription, topicMetrics, subscriptionMetrics);
    }

    private List<SubscriptionNameWithMetrics> getSubscriptionsMetrics() {
        return this.getAllSubscriptions().stream().map(s -> {
            SubscriptionMetrics metrics = this.metricsRepository.loadMetrics(s.getTopicName(), s.getName());
            return SubscriptionNameWithMetrics.from((SubscriptionMetrics)metrics, (String)s.getName(), (String)s.getQualifiedTopicName());
        }).collect(Collectors.toList());
    }
}

