/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.retry.ExponentialBackoffRetry;
import pl.allegro.tech.hermes.infrastructure.zookeeper.counter.ZookeeperCounterException;

public class SummedSharedCounter {
    private final List<LoadingCache<String, DistributedAtomicLong>> distributedAtomicLongCaches;

    public SummedSharedCounter(List<CuratorFramework> curatorClients, int expireAfter, int distributedLoaderBackoff, int distributedLoaderRetries) {
        this.distributedAtomicLongCaches = curatorClients.stream().map(client -> this.buildLoadingCache((CuratorFramework)client, expireAfter, distributedLoaderBackoff, distributedLoaderRetries)).collect(Collectors.toList());
    }

    public long getValue(String path) {
        return this.distributedAtomicLongCaches.stream().map(distAtomicLong -> this.getValue((LoadingCache<String, DistributedAtomicLong>)distAtomicLong, path)).reduce(0L, (a, b) -> a + b);
    }

    private long getValue(LoadingCache<String, DistributedAtomicLong> distAtomicLong, String path) {
        try {
            return (Long)((DistributedAtomicLong)distAtomicLong.get((Object)path)).get().preValue();
        }
        catch (Exception e) {
            throw new ZookeeperCounterException(path, (Throwable)e);
        }
    }

    private LoadingCache<String, DistributedAtomicLong> buildLoadingCache(final CuratorFramework curatorClient, int expireAfter, final int distributedLoaderBackoff, final int distributedLoaderRetries) {
        return CacheBuilder.newBuilder().expireAfterAccess((long)expireAfter, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, DistributedAtomicLong>(){

            public DistributedAtomicLong load(String key) {
                return new DistributedAtomicLong(curatorClient, key, (RetryPolicy)new ExponentialBackoffRetry(distributedLoaderBackoff, distributedLoaderRetries));
            }
        });
    }
}

