/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import pl.allegro.tech.hermes.common.admin.AdminTool;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminTool;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.common.kafka.offset.SubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.common.message.undelivered.ZookeeperUndeliveredMessageLog;
import pl.allegro.tech.hermes.domain.CredentialsRepository;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.domain.topic.preview.MessagePreviewRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperCredentialsRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperMessagePreviewRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperOAuthProviderRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperTopicRepository;
import pl.allegro.tech.hermes.management.config.storage.ZookeeperGroupRepositoryFactory;
import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistRepository;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryManager;
import pl.allegro.tech.hermes.management.infrastructure.blacklist.ZookeeperTopicBlacklistRepository;
import pl.allegro.tech.hermes.management.infrastructure.dc.DatacenterNameProvider;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClient;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClientManager;

public class ZookeeperRepositoryManager
implements RepositoryManager {
    private final DatacenterNameProvider datacenterNameProvider;
    private final ObjectMapper mapper;
    private final ZookeeperPaths paths;
    private final ZookeeperClientManager clientManager;
    private ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory;
    private Integer adminReaperInterval;
    private final Map<Class<?>, Object> repositoryByType = new HashMap();
    private final Map<String, GroupRepository> groupRepositoriesByDc = new HashMap<String, GroupRepository>();
    private final Map<String, CredentialsRepository> credentialsRepositoriesByDc = new HashMap<String, CredentialsRepository>();
    private final Map<String, TopicRepository> topicRepositoriesByDc = new HashMap<String, TopicRepository>();
    private final Map<String, SubscriptionRepository> subscriptionRepositoriesByDc = new HashMap<String, SubscriptionRepository>();
    private final Map<String, OAuthProviderRepository> oAuthProviderRepositoriesByDc = new HashMap<String, OAuthProviderRepository>();
    private final Map<String, SubscriptionOffsetChangeIndicator> offsetChangeIndicatorsByDc = new HashMap<String, SubscriptionOffsetChangeIndicator>();
    private final Map<String, MessagePreviewRepository> messagePreviewRepositoriesByDc = new HashMap<String, MessagePreviewRepository>();
    private final Map<String, TopicBlacklistRepository> topicBlacklistRepositoriesByDc = new HashMap<String, TopicBlacklistRepository>();
    private final Map<String, UndeliveredMessageLog> undeliveredMessageLogsByDc = new HashMap<String, UndeliveredMessageLog>();
    private final Map<String, AdminTool> adminToolByDc = new HashMap<String, AdminTool>();

    public ZookeeperRepositoryManager(ZookeeperClientManager clientManager, DatacenterNameProvider datacenterNameProvider, ObjectMapper mapper, ZookeeperPaths paths, ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory, Integer adminReaperInterval) {
        this.datacenterNameProvider = datacenterNameProvider;
        this.mapper = mapper;
        this.paths = paths;
        this.clientManager = clientManager;
        this.zookeeperGroupRepositoryFactory = zookeeperGroupRepositoryFactory;
        this.adminReaperInterval = adminReaperInterval;
        this.initRepositoryTypeMap();
    }

    public void start() {
        for (ZookeeperClient client : this.clientManager.getClients()) {
            String dcName = client.getDatacenterName();
            CuratorFramework zookeeper = client.getCuratorFramework();
            GroupRepository groupRepository = this.zookeeperGroupRepositoryFactory.create(zookeeper, this.mapper, this.paths);
            ZookeeperCredentialsRepository credentialsRepository = new ZookeeperCredentialsRepository(zookeeper, this.mapper, this.paths);
            ZookeeperTopicRepository topicRepository = new ZookeeperTopicRepository(zookeeper, this.mapper, this.paths, groupRepository);
            ZookeeperSubscriptionRepository subscriptionRepository = new ZookeeperSubscriptionRepository(zookeeper, this.mapper, this.paths, (TopicRepository)topicRepository);
            ZookeeperOAuthProviderRepository oAuthProviderRepository = new ZookeeperOAuthProviderRepository(zookeeper, this.mapper, this.paths);
            ZookeeperSubscriptionOffsetChangeIndicator offsetChangeIndicator = new ZookeeperSubscriptionOffsetChangeIndicator(zookeeper, this.paths, (SubscriptionRepository)subscriptionRepository);
            ZookeeperMessagePreviewRepository messagePreviewRepository = new ZookeeperMessagePreviewRepository(zookeeper, this.mapper, this.paths);
            ZookeeperTopicBlacklistRepository topicBlacklistRepository = new ZookeeperTopicBlacklistRepository(zookeeper, this.mapper, this.paths);
            ZookeeperUndeliveredMessageLog undeliveredMessageLog = new ZookeeperUndeliveredMessageLog(zookeeper, this.paths, this.mapper);
            ZookeeperAdminTool adminTool = new ZookeeperAdminTool(this.paths, client.getCuratorFramework(), this.mapper, this.adminReaperInterval.intValue());
            adminTool.start();
            this.groupRepositoriesByDc.put(dcName, groupRepository);
            this.credentialsRepositoriesByDc.put(dcName, (CredentialsRepository)credentialsRepository);
            this.topicRepositoriesByDc.put(dcName, (TopicRepository)topicRepository);
            this.subscriptionRepositoriesByDc.put(dcName, (SubscriptionRepository)subscriptionRepository);
            this.oAuthProviderRepositoriesByDc.put(dcName, (OAuthProviderRepository)oAuthProviderRepository);
            this.offsetChangeIndicatorsByDc.put(dcName, (SubscriptionOffsetChangeIndicator)offsetChangeIndicator);
            this.messagePreviewRepositoriesByDc.put(dcName, (MessagePreviewRepository)messagePreviewRepository);
            this.topicBlacklistRepositoriesByDc.put(dcName, topicBlacklistRepository);
            this.undeliveredMessageLogsByDc.put(dcName, (UndeliveredMessageLog)undeliveredMessageLog);
            this.adminToolByDc.put(dcName, (AdminTool)adminTool);
        }
    }

    @Override
    public <T> DatacenterBoundRepositoryHolder<T> getLocalRepository(Class<T> repositoryType) {
        String dcName = this.datacenterNameProvider.getDatacenterName();
        T repository = this.getRepositoriesByType(repositoryType).get(dcName);
        if (repository == null) {
            throw new InternalProcessingException("Failed to find '" + repositoryType.getSimpleName() + "' bound with DC '" + dcName + "'.");
        }
        return new DatacenterBoundRepositoryHolder<T>(repository, dcName);
    }

    @Override
    public <T> List<DatacenterBoundRepositoryHolder<T>> getRepositories(Class<T> repositoryType) {
        return this.getRepositoriesByType(repositoryType).entrySet().stream().map(entry -> new DatacenterBoundRepositoryHolder(entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }

    private <T> Map<String, T> getRepositoriesByType(Class<T> type) {
        Object repository = this.repositoryByType.get(type);
        if (repository == null) {
            throw new InternalProcessingException("Could not provide repository of type: " + type.getName());
        }
        return (Map)repository;
    }

    private void initRepositoryTypeMap() {
        this.repositoryByType.put(GroupRepository.class, this.groupRepositoriesByDc);
        this.repositoryByType.put(CredentialsRepository.class, this.credentialsRepositoriesByDc);
        this.repositoryByType.put(TopicRepository.class, this.topicRepositoriesByDc);
        this.repositoryByType.put(SubscriptionRepository.class, this.subscriptionRepositoriesByDc);
        this.repositoryByType.put(OAuthProviderRepository.class, this.oAuthProviderRepositoriesByDc);
        this.repositoryByType.put(SubscriptionOffsetChangeIndicator.class, this.offsetChangeIndicatorsByDc);
        this.repositoryByType.put(MessagePreviewRepository.class, this.messagePreviewRepositoriesByDc);
        this.repositoryByType.put(TopicBlacklistRepository.class, this.topicBlacklistRepositoriesByDc);
        this.repositoryByType.put(UndeliveredMessageLog.class, this.undeliveredMessageLogsByDc);
        this.repositoryByType.put(AdminTool.class, this.adminToolByDc);
    }
}

