/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.matcher;

import java.util.Arrays;
import org.apache.commons.jxpath.JXPathException;
import pl.allegro.tech.hermes.management.infrastructure.query.graph.ObjectGraph;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherException;

public class InMatcher
implements Matcher {
    private final String attribute;
    private final Object[] values;

    public InMatcher(String attribute, Object[] values) {
        this.attribute = attribute;
        this.values = values;
    }

    @Override
    public boolean match(Object value) {
        try {
            if (this.values == null || this.values.length == 0) {
                return false;
            }
            Object actual = ObjectGraph.from(value).navigate(this.attribute).value();
            return actual != null && (this.contains(actual) || this.contains(this.asString(actual)));
        }
        catch (JXPathException e) {
            throw new MatcherException(String.format("Could not navigate to specific path: '%s'", this.attribute), e);
        }
    }

    private boolean contains(Object actual) {
        return Arrays.stream(this.values).anyMatch(actual::equals);
    }

    private String asString(Object actual) {
        return String.valueOf(actual);
    }
}

