/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.matcher;

import java.util.Optional;
import org.apache.commons.jxpath.JXPathException;
import pl.allegro.tech.hermes.management.infrastructure.query.graph.ObjectGraph;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.ComparisonOperator;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherException;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherInputException;

public class ComparisonMatcher
implements Matcher {
    private final String attribute;
    private final Object rightSideValue;
    private final ComparisonOperator operator;

    public ComparisonMatcher(String attribute, Object rightSideValue, ComparisonOperator operator) {
        this.attribute = attribute;
        this.rightSideValue = rightSideValue;
        this.operator = operator;
    }

    @Override
    public boolean match(Object object) {
        Object leftSideValue = this.extractAttributeValue(object);
        Optional<Double> leftSideValueAsNumber = this.tryParseNumber(leftSideValue);
        Optional<Double> rightSideValueAsNumber = this.tryParseNumber(this.rightSideValue);
        if (!leftSideValueAsNumber.isPresent()) {
            return true;
        }
        if (!rightSideValueAsNumber.isPresent()) {
            throw new MatcherInputException("Comparison operator requires numerical data");
        }
        return this.makeComparison(leftSideValueAsNumber.get(), rightSideValueAsNumber.get());
    }

    private Object extractAttributeValue(Object object) {
        try {
            Object value = ObjectGraph.from(object).navigate(this.attribute).value();
            if (value == null) {
                throw new MatcherInputException(String.format("Cannot find '%s' attribute", this.attribute));
            }
            return value;
        }
        catch (JXPathException e) {
            throw new MatcherException(String.format("Could not navigate to specific path: '%s'", this.attribute), e);
        }
    }

    private Optional<Double> tryParseNumber(Object value) {
        try {
            return Optional.of(Double.parseDouble(this.asString(value)));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private boolean makeComparison(Double leftSideNumber, Double rightSideNumber) {
        return this.operator.compare(leftSideNumber, rightSideNumber);
    }

    private String asString(Object value) {
        return String.valueOf(value);
    }
}

