/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.workload.constraints.command;

import pl.allegro.tech.hermes.api.Constraints;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class CreateTopicConstraintsRepositoryCommand
extends RepositoryCommand<WorkloadConstraintsRepository> {
    private final TopicName topicName;
    private final Constraints constraints;
    private boolean exist;

    public CreateTopicConstraintsRepositoryCommand(TopicName topicName, Constraints constraints) {
        this.topicName = topicName;
        this.constraints = constraints;
    }

    @Override
    public void backup(WorkloadConstraintsRepository repository) {
        this.exist = repository.constraintsExist(this.topicName);
    }

    @Override
    public void execute(WorkloadConstraintsRepository repository) {
        repository.createConstraints(this.topicName, this.constraints);
    }

    @Override
    public void rollback(WorkloadConstraintsRepository repository) {
        if (!this.exist) {
            repository.deleteConstraints(this.topicName);
        }
    }

    @Override
    public Class<WorkloadConstraintsRepository> getRepositoryType() {
        return WorkloadConstraintsRepository.class;
    }

    public String toString() {
        return String.format("CreateTopicConstraints(%s)", this.topicName.qualifiedName());
    }
}

