/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config.console;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="console")
public class ConsoleProperties {
    private Console console = new Console();
    private Dashboard dashboard = new Dashboard();
    private Hermes hermes = new Hermes();
    private Metrics metrics = new Metrics();
    private Auth auth = new Auth();
    private Owner owner = new Owner();
    private TopicView topic = new TopicView();
    private SubscriptionView subscription = new SubscriptionView();
    private ConsistencyView consistency = new ConsistencyView();

    public Dashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    public Hermes getHermes() {
        return this.hermes;
    }

    public void setHermes(Hermes hermes) {
        this.hermes = hermes;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public Console getConsole() {
        return this.console;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public ConsistencyView getConsistency() {
        return this.consistency;
    }

    public void setConsistency(ConsistencyView consistency) {
        this.consistency = consistency;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public TopicView getTopic() {
        return this.topic;
    }

    public void setTopic(TopicView topic) {
        this.topic = topic;
    }

    public SubscriptionView getSubscription() {
        return this.subscription;
    }

    public void setSubscription(SubscriptionView subscription) {
        this.subscription = subscription;
    }

    public static final class ConsistencyView {
        private int maxGroupBatchSize = 10;

        public int getMaxGroupBatchSize() {
            return this.maxGroupBatchSize;
        }

        public void setMaxGroupBatchSize(int maxGroupBatchSize) {
            this.maxGroupBatchSize = maxGroupBatchSize;
        }
    }

    public static final class SubscriptionDeliveryType {
        private String value = "";
        private String label = "";

        public SubscriptionDeliveryType() {
        }

        public SubscriptionDeliveryType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }

    public static final class SubscriptionPolicy {
        private int messageTtl = 3600;

        public int getMessageTtl() {
            return this.messageTtl;
        }

        public void setMessageTtl(int messageTtl) {
            this.messageTtl = messageTtl;
        }
    }

    public static final class DefaultSubscriptionView {
        private SubscriptionPolicy subscriptionPolicy = new SubscriptionPolicy();
        private String deliveryType = "SERIAL";

        public SubscriptionPolicy getSubscriptionPolicy() {
            return this.subscriptionPolicy;
        }

        public void setSubscriptionPolicy(SubscriptionPolicy subscriptionPolicy) {
            this.subscriptionPolicy = subscriptionPolicy;
        }

        public String getDeliveryType() {
            return this.deliveryType;
        }

        public void setDeliveryType(String deliveryType) {
            this.deliveryType = deliveryType;
        }
    }

    public static final class EndpointAddressResolverMetadata {
        private String title;
        private String type;
        private String hint;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getHint() {
            return this.hint;
        }

        public void setHint(String hint) {
            this.hint = hint;
        }
    }

    public static final class SubscriptionView {
        private Map<String, EndpointAddressResolverMetadata> endpointAddressResolverMetadata = new HashMap<String, EndpointAddressResolverMetadata>();
        private boolean showHeadersFilter = false;
        private DefaultSubscriptionView defaults = new DefaultSubscriptionView();
        private List<SubscriptionDeliveryType> deliveryTypes = Lists.newArrayList((Object[])new SubscriptionDeliveryType[]{new SubscriptionDeliveryType("SERIAL", "SERIAL"), new SubscriptionDeliveryType("BATCH", "BATCH")});

        public Map<String, EndpointAddressResolverMetadata> getEndpointAddressResolverMetadata() {
            return this.endpointAddressResolverMetadata;
        }

        public void setEndpointAddressResolverMetadata(Map<String, EndpointAddressResolverMetadata> endpointAddressResolverMetadata) {
            this.endpointAddressResolverMetadata = endpointAddressResolverMetadata;
        }

        public boolean isShowHeadersFilter() {
            return this.showHeadersFilter;
        }

        public void setShowHeadersFilter(boolean showHeadersFilter) {
            this.showHeadersFilter = showHeadersFilter;
        }

        public DefaultSubscriptionView getDefaults() {
            return this.defaults;
        }

        public void setDefaults(DefaultSubscriptionView defaults) {
            this.defaults = defaults;
        }

        public List<SubscriptionDeliveryType> getDeliveryTypes() {
            return this.deliveryTypes;
        }

        public void setDeliveryTypes(List<SubscriptionDeliveryType> deliveryTypes) {
            this.deliveryTypes = deliveryTypes;
        }
    }

    public static final class OwnerSource {
        private String name = "";
        private String placeholder = "";

        public OwnerSource() {
        }

        public OwnerSource(String name, String placeholder) {
            this.name = name;
            this.placeholder = placeholder;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }
    }

    public static final class Owner {
        private List<OwnerSource> sources = Lists.newArrayList((Object[])new OwnerSource[]{new OwnerSource("Crowd", "Crowd group (or groups separated by ',')")});

        public List<OwnerSource> getSources() {
            return this.sources;
        }

        public void setSources(List<OwnerSource> sources) {
            this.sources = sources;
        }
    }

    public static final class TopicContentType {
        private String value = "";
        private String label = "";

        public TopicContentType() {
        }

        public TopicContentType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }

    public static final class RetentionTime {
        private int duration = 1;

        public int getDuration() {
            return this.duration;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }
    }

    public static final class DefaultTopicView {
        private String ack = "LEADER";
        private String contentType = "JSON";
        private RetentionTime retentionTime = new RetentionTime();

        public String getAck() {
            return this.ack;
        }

        public void setAck(String ack) {
            this.ack = ack;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public RetentionTime getRetentionTime() {
            return this.retentionTime;
        }

        public void setRetentionTime(RetentionTime retentionTime) {
            this.retentionTime = retentionTime;
        }
    }

    public static final class TopicView {
        private boolean messagePreviewEnabled = true;
        private boolean offlineClientsEnabled = false;
        private boolean authEnabled = true;
        private DefaultTopicView defaults = new DefaultTopicView();
        private String buttonsExtension = "";
        private boolean removeSchema = false;
        private boolean schemaIdAwareSerializationEnabled = false;
        private List<TopicContentType> contentTypes = Lists.newArrayList((Object[])new TopicContentType[]{new TopicContentType("AVRO", "AVRO"), new TopicContentType("JSON", "JSON")});
        private boolean readOnlyModeEnabled = false;
        private Set<String> allowedTopicLabels = Collections.emptySet();

        public boolean isMessagePreviewEnabled() {
            return this.messagePreviewEnabled;
        }

        public void setMessagePreviewEnabled(boolean messagePreviewEnabled) {
            this.messagePreviewEnabled = messagePreviewEnabled;
        }

        public boolean isOfflineClientsEnabled() {
            return this.offlineClientsEnabled;
        }

        public void setOfflineClientsEnabled(boolean offlineClientsEnabled) {
            this.offlineClientsEnabled = offlineClientsEnabled;
        }

        public boolean isAuthEnabled() {
            return this.authEnabled;
        }

        public void setAuthEnabled(boolean authEnabled) {
            this.authEnabled = authEnabled;
        }

        public DefaultTopicView getDefaults() {
            return this.defaults;
        }

        public void setDefaults(DefaultTopicView defaults) {
            this.defaults = defaults;
        }

        public List<TopicContentType> getContentTypes() {
            return this.contentTypes;
        }

        public void setContentTypes(List<TopicContentType> contentTypes) {
            this.contentTypes = contentTypes;
        }

        public Set<String> getAllowedTopicLabels() {
            return this.allowedTopicLabels;
        }

        public void setAllowedTopicLabels(Set<String> allowedTopicLabels) {
            this.allowedTopicLabels = allowedTopicLabels;
        }

        public String getButtonsExtension() {
            return this.buttonsExtension;
        }

        public void setButtonsExtension(String buttonsExtension) {
            this.buttonsExtension = buttonsExtension;
        }

        public boolean isRemoveSchema() {
            return this.removeSchema;
        }

        public void setRemoveSchema(boolean removeSchema) {
            this.removeSchema = removeSchema;
        }

        public boolean isSchemaIdAwareSerializationEnabled() {
            return this.schemaIdAwareSerializationEnabled;
        }

        public void setSchemaIdAwareSerializationEnabled(boolean schemaIdAwareSerializationEnabled) {
            this.schemaIdAwareSerializationEnabled = schemaIdAwareSerializationEnabled;
        }

        public boolean isReadOnlyModeEnabled() {
            return this.readOnlyModeEnabled;
        }

        public void setReadOnlyModeEnabled(boolean readOnlyModeEnabled) {
            this.readOnlyModeEnabled = readOnlyModeEnabled;
        }
    }

    public static final class AuthHeaders {
        private boolean enabled = false;
        private String adminHeader = "Hermes-Admin-Password";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getAdminHeader() {
            return this.adminHeader;
        }

        public void setAdminHeader(String adminHeader) {
            this.adminHeader = adminHeader;
        }
    }

    public static final class OAuth {
        private boolean enabled = false;
        private String url = "localhost:8092/auth";
        private String clientId = "hermes";
        private String scope = "hermes";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }
    }

    public static final class Auth {
        private OAuth oauth = new OAuth();
        private AuthHeaders headers = new AuthHeaders();

        public OAuth getOauth() {
            return this.oauth;
        }

        public void setOauth(OAuth oauth) {
            this.oauth = oauth;
        }

        public AuthHeaders getHeaders() {
            return this.headers;
        }

        public void setHeaders(AuthHeaders headers) {
            this.headers = headers;
        }
    }

    public static final class Graphite {
        private String url = "localhost:8082";
        private String prefix = "hermes";

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public static final class Metrics {
        private String type = "graphite";
        private Graphite graphite = new Graphite();

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Graphite getGraphite() {
            return this.graphite;
        }

        public void setGraphite(Graphite graphite) {
            this.graphite = graphite;
        }
    }

    public static final class SimpleDiscovery {
        private String url = "";

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static final class Discovery {
        private String type = "simple";
        private SimpleDiscovery simple = new SimpleDiscovery();

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public SimpleDiscovery getSimple() {
            return this.simple;
        }

        public void setSimple(SimpleDiscovery simple) {
            this.simple = simple;
        }
    }

    public static final class Hermes {
        private Discovery discovery = new Discovery();

        public Discovery getDiscovery() {
            return this.discovery;
        }

        public void setDiscovery(Discovery discovery) {
            this.discovery = discovery;
        }
    }

    public static final class Dashboard {
        private String metrics = "http://localhost:8082";
        private String docs = "http://hermes-pubsub.rtfd.org";

        public String getMetrics() {
            return this.metrics;
        }

        public void setMetrics(String metrics) {
            this.metrics = metrics;
        }

        public String getDocs() {
            return this.docs;
        }

        public void setDocs(String docs) {
            this.docs = docs;
        }
    }

    public static final class Console {
        private String title = "hermes console";
        private String footer = "";

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getFooter() {
            return this.footer;
        }

        public void setFooter(String footer) {
            this.footer = footer;
        }
    }
}

