/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.schema.validator;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.management.config.TopicProperties;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.InvalidSchemaException;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidator;

@Component
public class AvroSchemaValidator
implements SchemaValidator {
    private final boolean metadataFieldIsRequired;
    private static final Schema HERMES_METADATA_SCHEMA = AvroSchemaValidator.metadataFieldSchema(AvroSchemaValidator.readAndParseResourceSchema("/avro-schema-metadata-field.avsc"));

    public AvroSchemaValidator(boolean metadataFieldIsRequired) {
        this.metadataFieldIsRequired = metadataFieldIsRequired;
    }

    @Autowired
    public AvroSchemaValidator(TopicProperties topicProperties) {
        this(topicProperties.isAvroContentTypeMetadataRequired());
    }

    @Override
    public void check(String schema) throws InvalidSchemaException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schema) ? 1 : 0) != 0, (Object)"Message schema cannot be empty");
        Schema parsedSchema = AvroSchemaValidator.parseSchema(schema);
        if (this.metadataFieldIsRequired) {
            this.checkHermesMetadataField(parsedSchema);
        }
    }

    private void checkHermesMetadataField(Schema parsedSchema) {
        boolean valid;
        Schema metadata = AvroSchemaValidator.metadataFieldSchema(parsedSchema);
        boolean metadataTypeMatches = HERMES_METADATA_SCHEMA.getType().equals((Object)metadata.getType());
        boolean metadataNestedTypesMatch = HERMES_METADATA_SCHEMA.getTypes().equals(metadata.getTypes());
        boolean bl = valid = metadataTypeMatches && metadataNestedTypesMatch;
        if (!valid) {
            throw new InvalidSchemaException("Invalid types used in field __metadata");
        }
    }

    private static Schema metadataFieldSchema(Schema schema) {
        Schema.Field metadata = schema.getField("__metadata");
        if (metadata == null) {
            throw new InvalidSchemaException("Missing Hermes __metadata field");
        }
        return metadata.schema();
    }

    private static Schema readAndParseResourceSchema(String resourceFilePath) {
        try {
            String schema = IOUtils.toString((InputStream)AvroSchemaValidator.class.getResourceAsStream(resourceFilePath), (String)"UTF-8");
            return AvroSchemaValidator.parseSchema(schema);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load schema with metadata");
        }
    }

    private static Schema parseSchema(String schema) {
        try {
            return new Schema.Parser().parse(schema);
        }
        catch (SchemaParseException e) {
            throw new InvalidSchemaException(e);
        }
    }
}

