/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.validator;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.groups.Default;
import java.util.Set;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.constraints.AdminPermitted;

@Component
public class ApiPreconditions {
    private final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public <T> void checkConstraints(T object, boolean skipAdminPermitted) {
        Class[] groups = this.groupsToValidate(skipAdminPermitted);
        Set violations = this.validator.validate(object, groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    private Class<?>[] groupsToValidate(boolean skipAdminPermitted) {
        if (skipAdminPermitted) {
            return new Class[]{Default.class};
        }
        return new Class[]{Default.class, AdminPermitted.class};
    }
}

