/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.readiness;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.DatacenterReadiness;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.QueryCommand;
import pl.allegro.tech.hermes.management.domain.readiness.ReadinessRepository;

public class GetReadinessQuery
extends QueryCommand<DatacenterReadiness.ReadinessStatus, ReadinessRepository> {
    private static final Logger logger = LoggerFactory.getLogger(GetReadinessQuery.class);

    @Override
    public DatacenterReadiness.ReadinessStatus query(DatacenterBoundRepositoryHolder<ReadinessRepository> holder) {
        try {
            boolean ready = holder.getRepository().isReady();
            return ready ? DatacenterReadiness.ReadinessStatus.READY : DatacenterReadiness.ReadinessStatus.NOT_READY;
        }
        catch (Exception e) {
            logger.error("Cannot obtain readiness status from {}", (Object)holder.getDatacenterName(), (Object)e);
            return DatacenterReadiness.ReadinessStatus.UNDEFINED;
        }
    }

    @Override
    public Class<ReadinessRepository> getRepositoryType() {
        return ReadinessRepository.class;
    }
}

