/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.kafka.ConsumerGroupId;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.management.config.kafka.KafkaProperties;

public class KafkaConsumerManager {
    private final KafkaNamesMapper kafkaNamesMapper;
    private final String bootstrapKafkaServer;
    private final KafkaProperties kafkaProperties;

    public KafkaConsumerManager(KafkaProperties kafkaProperties, KafkaNamesMapper kafkaNamesMapper, String bootstrapKafkaServer) {
        this.kafkaNamesMapper = kafkaNamesMapper;
        this.bootstrapKafkaServer = bootstrapKafkaServer;
        this.kafkaProperties = kafkaProperties;
    }

    public KafkaConsumer<byte[], byte[]> createConsumer(SubscriptionName subscription) {
        ConsumerGroupId groupId = this.kafkaNamesMapper.toConsumerGroupId(subscription);
        return new KafkaConsumer(this.properties(groupId));
    }

    private Properties properties(ConsumerGroupId groupId) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapKafkaServer);
        props.put("group.id", groupId.asString());
        props.put("enable.auto.commit", (Object)false);
        props.put("request.timeout.ms", (Object)5000);
        props.put("default.api.timeout.ms", (Object)5000);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        if (this.kafkaProperties.getSasl().isEnabled()) {
            props.put("sasl.mechanism", this.kafkaProperties.getSasl().getMechanism());
            props.put("security.protocol", this.kafkaProperties.getSasl().getProtocol());
            props.put("sasl.jaas.config", this.kafkaProperties.getSasl().getJaasConfig());
        }
        return props;
    }
}

