/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.prometheus;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringMetricsContainer;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusClient;

public class CachingPrometheusClient
implements PrometheusClient {
    private final PrometheusClient underlyingPrometheusClient;
    private final LoadingCache<String, MonitoringMetricsContainer> prometheusMetricsCache;

    public CachingPrometheusClient(PrometheusClient underlyingPrometheusClient, Ticker ticker, long cacheTtlInSeconds, long cacheSize) {
        this.underlyingPrometheusClient = underlyingPrometheusClient;
        this.prometheusMetricsCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(cacheTtlInSeconds, TimeUnit.SECONDS).maximumSize(cacheSize).build((CacheLoader)new PrometheusMetricsCacheLoader());
    }

    @Override
    public MonitoringMetricsContainer readMetrics(String query) {
        try {
            return (MonitoringMetricsContainer)this.prometheusMetricsCache.get((Object)query);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private class PrometheusMetricsCacheLoader
    extends CacheLoader<String, MonitoringMetricsContainer> {
        private PrometheusMetricsCacheLoader() {
        }

        public MonitoringMetricsContainer load(String query) {
            return CachingPrometheusClient.this.underlyingPrometheusClient.readMetrics(query);
        }
    }
}

