/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import java.util.Optional;
import pl.allegro.tech.hermes.api.SubscriptionHealthProblem;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthProblemIndicator;

public class ReceivingMalformedMessagesIndicator
implements SubscriptionHealthProblemIndicator {
    private final double max4xxErrorsRatio;
    private final double minSubscriptionRateForReliableMetrics;

    public ReceivingMalformedMessagesIndicator(double max4xxErrorsRatio, double minSubscriptionRateForReliableMetrics) {
        this.max4xxErrorsRatio = max4xxErrorsRatio;
        this.minSubscriptionRateForReliableMetrics = minSubscriptionRateForReliableMetrics;
    }

    @Override
    public Optional<SubscriptionHealthProblem> getProblem(SubscriptionHealthContext context) {
        if (context.subscriptionHasRetryOnError() && this.areSubscriptionMetricsReliable(context) && this.isCode4xxErrorsRateHigh(context)) {
            return Optional.of(SubscriptionHealthProblem.receivingMalformedMessages((double)context.getCode4xxErrorsRate(), (String)context.getSubscription().getQualifiedName().toString()));
        }
        return Optional.empty();
    }

    private boolean areSubscriptionMetricsReliable(SubscriptionHealthContext context) {
        return context.getSubscriptionRateRespectingDeliveryType() > this.minSubscriptionRateForReliableMetrics;
    }

    private boolean isCode4xxErrorsRateHigh(SubscriptionHealthContext context) {
        double rate;
        double code4xxErrorsRate = context.getCode4xxErrorsRate();
        return code4xxErrorsRate > this.max4xxErrorsRatio * (rate = context.getSubscriptionRateRespectingDeliveryType());
    }
}

