/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.ErrorCode;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.domain.ManagementException;
import pl.allegro.tech.hermes.management.domain.clients.IframeSource;
import pl.allegro.tech.hermes.management.domain.clients.OfflineClientsService;

@Component
@Path(value="/topics")
public class OfflineClientsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(OfflineClientsEndpoint.class);
    private final Optional<OfflineClientsService> offlineClientsService;

    OfflineClientsEndpoint(Optional<OfflineClientsService> offlineClientsService) {
        if (!offlineClientsService.isPresent()) {
            logger.info("Offline clients bean is absent");
        }
        this.offlineClientsService = offlineClientsService;
    }

    @GET
    @Path(value="/{topic}/offline-clients-source")
    @Produces(value={"application/json"})
    public Response find(@PathParam(value="topic") String topic) {
        return this.offlineClientsService.map(service -> Response.ok((Object)new IframeSource(service.getIframeSource(TopicName.fromQualifiedName((String)topic)))).build()).orElseThrow(OfflineClientsServiceAbsentException::new);
    }

    private static class OfflineClientsServiceAbsentException
    extends ManagementException {
        OfflineClientsServiceAbsentException() {
            super("Offline clients implementation is absent");
        }

        @Override
        public ErrorCode getCode() {
            return ErrorCode.IMPLEMENTATION_ABSENT;
        }
    }
}

