/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.ApiOperation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.Stats;
import pl.allegro.tech.hermes.api.SubscriptionStats;
import pl.allegro.tech.hermes.api.TopicStats;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionService;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;

@Path(value="stats")
public class StatsEndpoint {
    private final SubscriptionService subscriptionService;
    private final TopicService topicService;

    @Autowired
    public StatsEndpoint(SubscriptionService subscriptionService, TopicService topicService) {
        this.subscriptionService = subscriptionService;
        this.topicService = topicService;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get topic and subscription stats", response=Stats.class, httpMethod="GET")
    public Stats getStats() {
        TopicStats topicStats = this.topicService.getStats();
        SubscriptionStats subscriptionStats = this.subscriptionService.getStats();
        return new Stats(topicStats, subscriptionStats);
    }
}

