/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.kafka.ConsumerGroupId;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.management.config.kafka.KafkaProperties;

public class KafkaConsumerManager {
    private final KafkaNamesMapper kafkaNamesMapper;
    private final String brokerList;
    private final KafkaProperties kafkaProperties;

    public KafkaConsumerManager(KafkaProperties kafkaProperties, KafkaNamesMapper kafkaNamesMapper, String brokerList) {
        this.kafkaNamesMapper = kafkaNamesMapper;
        this.brokerList = brokerList;
        this.kafkaProperties = kafkaProperties;
    }

    public KafkaConsumer<byte[], byte[]> createConsumer(SubscriptionName subscription) {
        ConsumerGroupId groupId = this.kafkaNamesMapper.toConsumerGroupId(subscription);
        return new KafkaConsumer(this.properties(groupId));
    }

    private Properties properties(ConsumerGroupId groupId) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("group.id", groupId.asString());
        props.put("enable.auto.commit", (Object)false);
        props.put("request.timeout.ms", (Object)5000);
        props.put("default.api.timeout.ms", (Object)5000);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        if (this.kafkaProperties.getAuthentication().isEnabled()) {
            props.put("sasl.mechanism", this.kafkaProperties.getAuthentication().getMechanism());
            props.put("security.protocol", this.kafkaProperties.getAuthentication().getProtocol());
            props.put("sasl.jaas.config", this.kafkaProperties.getAuthentication().getJaasConfig());
        }
        return props;
    }
}

