/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.matcher;

import org.apache.commons.jxpath.JXPathException;
import pl.allegro.tech.hermes.management.infrastructure.query.graph.ObjectGraph;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherException;

public class EqualityMatcher
implements Matcher {
    private final String attribute;
    private final Object expected;

    public EqualityMatcher(String attribute, Object expected) {
        this.attribute = attribute;
        this.expected = expected;
    }

    @Override
    public boolean match(Object value) {
        try {
            if (this.expected == null) {
                return false;
            }
            Object actual = ObjectGraph.from(value).navigate(this.attribute).value();
            return this.expected.equals(actual) || EqualityMatcher.asString(this.expected).equals(EqualityMatcher.asString(actual));
        }
        catch (JXPathException e) {
            throw new MatcherException(String.format("Could not navigate to specific path: '%s'", this.attribute), e);
        }
    }

    private static String asString(Object value) {
        return String.valueOf(value);
    }
}

