/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.BlacklistStatus;
import pl.allegro.tech.hermes.management.api.auth.HermesSecurityAwareRequestUser;
import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistService;

@Component
@Path(value="/blacklist")
@Api(value="/blacklist", description="Operations on topics")
public class BlacklistEndpoint {
    private final TopicBlacklistService topicBlacklistService;

    @Autowired
    public BlacklistEndpoint(TopicBlacklistService topicBlacklistService) {
        this.topicBlacklistService = topicBlacklistService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/topics/{topicName}")
    @ApiOperation(value="Is topic blacklisted", httpMethod="GET")
    public BlacklistStatus isTopicBlacklisted(@PathParam(value="topicName") String qualifiedTopicName) {
        return this.topicBlacklistService.isBlacklisted(qualifiedTopicName) ? BlacklistStatus.BLACKLISTED : BlacklistStatus.NOT_BLACKLISTED;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/topics")
    @RolesAllowed(value={"admin"})
    public List<String> topicsBlacklist() {
        return this.topicBlacklistService.list();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/topics")
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Blacklist topics", httpMethod="POST")
    public Response blacklistTopics(List<String> qualifiedTopicNames, @Context ContainerRequestContext requestContext) {
        HermesSecurityAwareRequestUser blacklistRequester = new HermesSecurityAwareRequestUser(requestContext);
        qualifiedTopicNames.forEach(topicName -> this.topicBlacklistService.blacklist((String)topicName, blacklistRequester));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/topics/{topicName}")
    @RolesAllowed(value={"admin"})
    @ApiOperation(value="Unblacklist topic", httpMethod="DELETE")
    public Response unblacklistTopic(@PathParam(value="topicName") String qualifiedTopicName, @Context ContainerRequestContext requestContext) {
        HermesSecurityAwareRequestUser unblacklistRequester = new HermesSecurityAwareRequestUser(requestContext);
        this.topicBlacklistService.unblacklist(qualifiedTopicName, unblacklistRequester);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

