/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.consistency;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Group;
import pl.allegro.tech.hermes.api.InconsistentGroup;
import pl.allegro.tech.hermes.api.InconsistentMetadata;
import pl.allegro.tech.hermes.api.InconsistentSubscription;
import pl.allegro.tech.hermes.api.InconsistentTopic;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.group.GroupNotExistsException;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.topic.TopicNotExistsException;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.config.ConsistencyCheckerProperties;
import pl.allegro.tech.hermes.management.domain.consistency.ConsistencyCheckingException;
import pl.allegro.tech.hermes.management.domain.consistency.MetadataCopies;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryManager;

@Component
public class DcConsistencyService {
    private final ExecutorService executor;
    private final List<DatacenterBoundRepositoryHolder<GroupRepository>> groupRepositories;
    private final List<DatacenterBoundRepositoryHolder<TopicRepository>> topicRepositories;
    private final List<DatacenterBoundRepositoryHolder<SubscriptionRepository>> subscriptionRepositories;
    private final ObjectMapper objectMapper;

    public DcConsistencyService(RepositoryManager repositoryManager, ObjectMapper objectMapper, ConsistencyCheckerProperties properties) {
        this.groupRepositories = repositoryManager.getRepositories(GroupRepository.class);
        this.topicRepositories = repositoryManager.getRepositories(TopicRepository.class);
        this.subscriptionRepositories = repositoryManager.getRepositories(SubscriptionRepository.class);
        this.objectMapper = objectMapper;
        this.executor = Executors.newFixedThreadPool(properties.getThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat("consistency-checker-%d").build());
    }

    @PreDestroy
    public void stop() {
        this.executor.shutdown();
    }

    public List<InconsistentGroup> listInconsistentGroups(Set<String> groupNames) {
        ArrayList<InconsistentGroup> inconsistentGroups = new ArrayList<InconsistentGroup>();
        for (MetadataCopies copies : this.listCopiesOfGroups(groupNames)) {
            List<InconsistentMetadata> inconsistentMetadata = this.findInconsistentMetadata(copies);
            List<InconsistentTopic> inconsistentTopics = this.listInconsistentTopics(copies.getId());
            if (inconsistentMetadata.isEmpty() && inconsistentTopics.isEmpty()) continue;
            inconsistentGroups.add(new InconsistentGroup(copies.getId(), inconsistentMetadata, inconsistentTopics));
        }
        return inconsistentGroups;
    }

    private List<MetadataCopies> listCopiesOfGroups(Set<String> groupNames) {
        HashMap futuresPerDatacenter = new HashMap();
        for (DatacenterBoundRepositoryHolder<GroupRepository> repositoryHolder : this.groupRepositories) {
            Future<List> future = this.executor.submit(() -> this.listGroups((GroupRepository)repositoryHolder.getRepository(), groupNames));
            futuresPerDatacenter.put(repositoryHolder.getDatacenterName(), future);
        }
        return this.listCopies(futuresPerDatacenter, Group::getGroupName);
    }

    private List<Group> listGroups(GroupRepository repository, Set<String> groupNames) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String groupName : groupNames) {
            try {
                Group group = repository.getGroupDetails(groupName);
                groups.add(group);
            }
            catch (GroupNotExistsException groupNotExistsException) {}
        }
        return groups;
    }

    private List<InconsistentTopic> listInconsistentTopics(String group) {
        ArrayList<InconsistentTopic> inconsistentTopics = new ArrayList<InconsistentTopic>();
        for (MetadataCopies copies : this.listCopiesOfTopicsFromGroup(group)) {
            List<InconsistentMetadata> inconsistentMetadata = this.findInconsistentMetadata(copies);
            List<InconsistentSubscription> inconsistentSubscriptions = this.listInconsistentSubscriptions(copies.getId());
            if (inconsistentMetadata.isEmpty() && inconsistentSubscriptions.isEmpty()) continue;
            inconsistentTopics.add(new InconsistentTopic(copies.getId(), inconsistentMetadata, inconsistentSubscriptions));
        }
        return inconsistentTopics;
    }

    private List<MetadataCopies> listCopiesOfTopicsFromGroup(String group) {
        HashMap futuresPerDatacenter = new HashMap();
        for (DatacenterBoundRepositoryHolder<TopicRepository> repositoryHolder : this.topicRepositories) {
            Future<List> future = this.executor.submit(() -> this.listTopics((TopicRepository)repositoryHolder.getRepository(), group));
            futuresPerDatacenter.put(repositoryHolder.getDatacenterName(), future);
        }
        return this.listCopies(futuresPerDatacenter, Topic::getQualifiedName);
    }

    private List<Topic> listTopics(TopicRepository topicRepository, String group) {
        try {
            return topicRepository.listTopics(group);
        }
        catch (GroupNotExistsException e) {
            return Collections.emptyList();
        }
    }

    private List<InconsistentSubscription> listInconsistentSubscriptions(String topic) {
        return this.listCopiesOfSubscriptionsFromTopic(topic).stream().filter(copies -> !copies.areAllEqual()).map(copies -> new InconsistentSubscription(copies.getId(), this.findInconsistentMetadata((MetadataCopies)copies))).collect(Collectors.toList());
    }

    private List<MetadataCopies> listCopiesOfSubscriptionsFromTopic(String topic) {
        HashMap futuresPerDatacenter = new HashMap();
        for (DatacenterBoundRepositoryHolder<SubscriptionRepository> repositoryHolder : this.subscriptionRepositories) {
            Future<List> future = this.executor.submit(() -> this.listSubscriptions((SubscriptionRepository)repositoryHolder.getRepository(), topic));
            futuresPerDatacenter.put(repositoryHolder.getDatacenterName(), future);
        }
        return this.listCopies(futuresPerDatacenter, subscription -> subscription.getQualifiedName().getQualifiedName());
    }

    private List<Subscription> listSubscriptions(SubscriptionRepository subscriptionRepository, String topic) {
        try {
            return subscriptionRepository.listSubscriptions(TopicName.fromQualifiedName((String)topic));
        }
        catch (TopicNotExistsException e) {
            return Collections.emptyList();
        }
    }

    private <T> List<MetadataCopies> listCopies(Map<String, Future<List<T>>> futuresPerDatacenter, Function<T, String> idResolver) {
        HashMap<String, MetadataCopies> copiesPerId = new HashMap<String, MetadataCopies>();
        Set<String> datacenters = futuresPerDatacenter.keySet();
        for (Map.Entry<String, Future<List<T>>> entry : futuresPerDatacenter.entrySet()) {
            List<T> entities = this.resolveFuture(entry.getValue());
            String datacenter = entry.getKey();
            for (T entity : entities) {
                String id = idResolver.apply(entity);
                MetadataCopies copies = copiesPerId.getOrDefault(id, new MetadataCopies(id, datacenters));
                copies.put(datacenter, entity);
                copiesPerId.put(id, copies);
            }
        }
        return new ArrayList<MetadataCopies>(copiesPerId.values());
    }

    private List<InconsistentMetadata> findInconsistentMetadata(MetadataCopies copies) {
        if (copies.areAllEqual()) {
            return Collections.emptyList();
        }
        return copies.getCopyPerDatacenter().entrySet().stream().map(entry -> this.mapToInconsistentMetadata((String)entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    private InconsistentMetadata mapToInconsistentMetadata(String id, Object content) {
        try {
            if (content == null) {
                return new InconsistentMetadata(id, null);
            }
            return new InconsistentMetadata(id, this.objectMapper.writeValueAsString(content));
        }
        catch (JsonProcessingException e) {
            throw new ConsistencyCheckingException("Metadata serialization failed", e);
        }
    }

    public Set<String> listAllGroupNames() {
        ArrayList<Future<List>> results = new ArrayList<Future<List>>();
        for (DatacenterBoundRepositoryHolder<GroupRepository> repositoryHolder : this.groupRepositories) {
            Future<List> submit = this.executor.submit(() -> ((GroupRepository)repositoryHolder.getRepository()).listGroupNames());
            results.add(submit);
        }
        return results.stream().map(this::resolveFuture).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private <T> T resolveFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new ConsistencyCheckingException("Fetching metadata failed", e);
        }
    }
}

