/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.metrics;

import java.util.HashMap;
import java.util.Map;
import pl.allegro.tech.hermes.api.MetricDecimalValue;

public class MonitoringMetricsContainer {
    private static final MetricDecimalValue DEFAULT_VALUE = MetricDecimalValue.of((String)"0.0");
    private final Map<String, MetricDecimalValue> metrics;
    private final boolean isAvailable;

    private MonitoringMetricsContainer(boolean isAvailable, Map<String, MetricDecimalValue> metrics) {
        this.metrics = metrics;
        this.isAvailable = isAvailable;
    }

    public static MonitoringMetricsContainer createEmpty() {
        return new MonitoringMetricsContainer(true, new HashMap<String, MetricDecimalValue>());
    }

    public static MonitoringMetricsContainer initialized(Map<String, MetricDecimalValue> metrics) {
        return new MonitoringMetricsContainer(true, metrics);
    }

    public static MonitoringMetricsContainer unavailable() {
        return new MonitoringMetricsContainer(false, new HashMap<String, MetricDecimalValue>());
    }

    public MonitoringMetricsContainer addMetricValue(String metricPath, MetricDecimalValue value) {
        if (!this.isAvailable) {
            throw new IllegalStateException("Adding value to unavailable metrics container");
        }
        this.metrics.put(metricPath, value);
        return this;
    }

    public MetricDecimalValue metricValue(String metricPath) {
        if (!this.isAvailable) {
            return MetricDecimalValue.unavailable();
        }
        return this.metrics.getOrDefault(metricPath, DEFAULT_VALUE);
    }
}

