/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.project13.jgit.DescribeResult;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.StdOutLoggerBridge;
import pl.project13.maven.git.util.Pair;

public class DescribeCommand
extends GitCommand<DescribeResult> {
    private LoggerBridge loggerBridge;
    private int abbrev = 7;
    private boolean tagsFlag = false;
    private boolean alwaysFlag = true;
    private boolean forceLongFormat = false;
    private Optional<String> dirtyOption = Optional.absent();

    @NotNull
    public static DescribeCommand on(Repository repo) {
        return new DescribeCommand(repo);
    }

    private DescribeCommand(Repository repo) {
        this(repo, true);
    }

    private DescribeCommand(Repository repo, boolean verbose) {
        super(repo);
        this.initDefaultLoggerBridge(verbose);
        this.setVerbose(verbose);
    }

    private void initDefaultLoggerBridge(boolean verbose) {
        this.loggerBridge = new StdOutLoggerBridge(verbose);
    }

    @NotNull
    public DescribeCommand setVerbose(boolean verbose) {
        this.loggerBridge.setVerbose(verbose);
        return this;
    }

    @NotNull
    public DescribeCommand withLoggerBridge(LoggerBridge bridge) {
        this.loggerBridge = bridge;
        return this;
    }

    @NotNull
    public DescribeCommand always(boolean always) {
        this.alwaysFlag = always;
        this.log("--always = %s", always);
        return this;
    }

    @NotNull
    public DescribeCommand forceLongFormat(@Nullable Boolean forceLongFormat) {
        if (forceLongFormat != null) {
            this.forceLongFormat = forceLongFormat;
            this.log("--long = %s", forceLongFormat);
        }
        return this;
    }

    @NotNull
    public DescribeCommand abbrev(@Nullable Integer n) {
        if (n != null) {
            Preconditions.checkArgument((n < 41 ? 1 : 0) != 0, (Object)String.format("N (commit abbres length) must be < 41. (Was:[%s])", n));
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)String.format("N (commit abbrev length) must be positive! (Was [%s])", n));
            this.log("--abbrev = %s", n);
            this.abbrev = n;
        }
        return this;
    }

    @NotNull
    public DescribeCommand tags(@Nullable Boolean includeLightweightTagsInSearch) {
        if (includeLightweightTagsInSearch != null) {
            this.tagsFlag = includeLightweightTagsInSearch;
            this.log("--tags %s", includeLightweightTagsInSearch);
        }
        return this;
    }

    public DescribeCommand tags() {
        return this.tags(true);
    }

    @NotNull
    public DescribeCommand apply(@Nullable GitDescribeConfig config) {
        if (config != null) {
            this.always(config.isAlways());
            this.dirty(config.getDirty());
            this.abbrev(config.getAbbrev());
            this.forceLongFormat(config.getForceLongFormat());
            this.tags(config.getTags());
        }
        return this;
    }

    @NotNull
    public DescribeCommand dirty(@Nullable String dirtyMarker) {
        if (dirtyMarker != null && dirtyMarker.length() > 0) {
            this.log("--dirty = \"-%s\"", dirtyMarker);
            this.dirtyOption = Optional.of((Object)dirtyMarker);
        }
        return this;
    }

    public DescribeResult call() throws GitAPIException {
        Map<ObjectId, String> tagObjectIdToName = this.findTagObjectIds(this.repo, this.tagsFlag);
        RevCommit headCommit = this.findHeadObjectId(this.repo);
        ObjectId headCommitId = headCommit.getId();
        boolean dirty = this.findDirtyState(this.repo);
        if (DescribeCommand.isATag((ObjectId)headCommit, tagObjectIdToName)) {
            String tagName = tagObjectIdToName.get(headCommit);
            this.log("The commit we're on is a Tag ([%s]), returning.", tagName);
            return new DescribeResult(tagName, dirty);
        }
        if (DescribeCommand.foundZeroTags(tagObjectIdToName)) {
            return new DescribeResult(headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        List<RevCommit> commits = this.findCommitsUntilSomeTag(this.repo, headCommit, tagObjectIdToName);
        int distance = this.distanceBetween(this.repo, headCommit, commits.get(0));
        String tagName = tagObjectIdToName.get(commits.get(0));
        Pair<Integer, String> howFarFromWhichTag = Pair.of(distance, tagName);
        return this.createDescribeResult(headCommitId, dirty, howFarFromWhichTag);
    }

    private DescribeResult createDescribeResult(ObjectId headCommitId, boolean dirty, @Nullable Pair<Integer, String> howFarFromWhichTag) {
        if (howFarFromWhichTag == null) {
            return new DescribeResult(headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first > 0 || this.forceLongFormat) {
            return new DescribeResult((String)howFarFromWhichTag.second, (int)((Integer)howFarFromWhichTag.first), headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first == 0) {
            return new DescribeResult((String)howFarFromWhichTag.second).withCommitIdAbbrev(this.abbrev);
        }
        if (this.alwaysFlag) {
            return new DescribeResult(headCommitId).withCommitIdAbbrev(this.abbrev);
        }
        return DescribeResult.EMPTY;
    }

    private static boolean foundZeroTags(@NotNull Map<ObjectId, String> tags) {
        return tags.isEmpty();
    }

    @VisibleForTesting
    boolean findDirtyState(Repository repo) throws GitAPIException {
        Git git = Git.wrap((Repository)repo);
        Status status = git.status().call();
        boolean isDirty = !status.isClean();
        this.log("Repo is in dirty state = [%s] ", isDirty);
        return isDirty;
    }

    @VisibleForTesting
    static boolean isATag(ObjectId headCommit, @NotNull Map<ObjectId, String> tagObjectIdToName) {
        return tagObjectIdToName.containsKey(headCommit);
    }

    RevCommit findHeadObjectId(@NotNull Repository repo) throws RuntimeException {
        try {
            ObjectId headId = repo.resolve("HEAD");
            RevWalk walk = new RevWalk(repo);
            RevCommit headCommit = walk.lookupCommit((AnyObjectId)headId);
            walk.dispose();
            this.log("HEAD is [%s] ", headCommit.getName());
            return headCommit;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to obtain HEAD commit!", ex);
        }
    }

    private List<RevCommit> findCommitsUntilSomeTag(Repository repo, RevCommit head, @NotNull Map<ObjectId, String> tagObjectIdToName) {
        RevWalk revWalk = new RevWalk(repo);
        try {
            revWalk.markStart(head);
            for (RevCommit commit : revWalk) {
                ObjectId objId = commit.getId();
                String lookup = tagObjectIdToName.get(objId);
                if (lookup == null) continue;
                return Collections.singletonList(commit);
            }
            throw new RuntimeException("Did not find any commits until some tag");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int distanceBetween(@NotNull Repository repo, @NotNull RevCommit child, @NotNull RevCommit parent) {
        RevWalk revWalk = new RevWalk(repo);
        try {
            revWalk.markStart(child);
            HashSet seena = Sets.newHashSet();
            HashSet seenb = Sets.newHashSet();
            LinkedList q = Lists.newLinkedList();
            q.add(revWalk.parseCommit((AnyObjectId)child));
            int distance = 0;
            ObjectId parentId = parent.getId();
            while (q.size() > 0) {
                RevCommit commit = (RevCommit)q.remove();
                ObjectId commitId = commit.getId();
                if (seena.contains(commitId)) continue;
                seena.add(commitId);
                if (parentId.equals((AnyObjectId)commitId)) {
                    DescribeCommand.seeAllParents(revWalk, commit, seenb);
                    for (ObjectId oid : seenb) {
                        if (!seena.contains(oid)) continue;
                        --distance;
                    }
                    seena.addAll(seenb);
                    continue;
                }
                for (RevCommit oid : commit.getParents()) {
                    if (seena.contains(oid)) continue;
                    q.add(revWalk.parseCommit((AnyObjectId)oid));
                }
                ++distance;
            }
            int n = distance;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to calculate distance between [%s] and [%s]", child, parent), e);
        }
        finally {
            revWalk.dispose();
        }
    }

    private static void seeAllParents(@NotNull RevWalk revWalk, RevCommit child, @NotNull Set<ObjectId> seen) throws IOException {
        LinkedList q = Lists.newLinkedList();
        q.add(child);
        while (q.size() > 0) {
            RevCommit commit = (RevCommit)q.remove();
            for (RevCommit oid : commit.getParents()) {
                if (seen.contains(oid)) continue;
                seen.add((ObjectId)oid);
                q.add(revWalk.parseCommit((AnyObjectId)oid));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ObjectId, String> findTagObjectIds(@NotNull Repository repo, boolean tagsFlag) {
        HashMap commitIdsToTagNames = Maps.newHashMap();
        RevWalk walk = new RevWalk(repo);
        try {
            walk.markStart(walk.parseCommit((AnyObjectId)repo.resolve("HEAD")));
            List tagRefs = Git.wrap((Repository)repo).tagList().call();
            for (Ref tagRef : tagRefs) {
                walk.reset();
                String name = tagRef.getName();
                ObjectId resolvedCommitId = repo.resolve(name);
                try {
                    RevTag revTag = walk.parseTag((AnyObjectId)resolvedCommitId);
                    ObjectId taggedCommitId = revTag.getObject().getId();
                    commitIdsToTagNames.put(taggedCommitId, DescribeCommand.trimFullTagName(name));
                }
                catch (IncorrectObjectTypeException ex) {
                    if (!tagsFlag) continue;
                    this.log("Including lightweight tag [%s]", name);
                    commitIdsToTagNames.put(resolvedCommitId, DescribeCommand.trimFullTagName(name));
                }
                catch (Exception ignored) {
                    this.log("Failed while parsing [%s] -- %s", tagRef, ignored);
                }
            }
            HashMap hashMap = commitIdsToTagNames;
            return hashMap;
        }
        catch (Exception e) {
            this.log("Unable to locate tags\n[%s]", Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            walk.release();
        }
        return Collections.emptyMap();
    }

    @VisibleForTesting
    static String trimFullTagName(@NotNull String tagName) {
        return tagName.replaceFirst("refs/tags/", "");
    }

    private void log(String msg, Object ... interpolations) {
        this.loggerBridge.log(msg, interpolations);
    }
}

