/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.jgit.lib.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescribeResult {
    public static final String DEFAULT_DIRTY_MARKER = "dirty";
    private Optional<String> tagName = Optional.absent();
    private Optional<ObjectId> commitId = Optional.absent();
    private int abbrev = 7;
    private int commitsAwayFromTag;
    private boolean dirty;
    private String dirtyMarker;
    public static final DescribeResult EMPTY = new DescribeResult("");

    public DescribeResult(String tagName) {
        this(tagName, 0, null);
    }

    public DescribeResult(ObjectId commitId) {
        this.commitId = Optional.of((Object)commitId);
    }

    public DescribeResult(String tagName, int commitsAwayFromTag, @Nullable ObjectId commitId) {
        this(tagName, commitsAwayFromTag, commitId, false, (Optional<String>)Optional.absent());
    }

    public DescribeResult(String tagName, int commitsAwayFromTag, ObjectId commitId, boolean dirty, String dirtyMarker) {
        this(tagName, commitsAwayFromTag, commitId, dirty, (Optional<String>)Optional.of((Object)dirtyMarker));
    }

    @NotNull
    public DescribeResult withCommitIdAbbrev(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)String.format("The --abbrev parameter must be >= 0, but it was: [%s]", n));
        this.abbrev = n;
        return this;
    }

    public DescribeResult(String tagName, int commitsAwayFromTag, ObjectId commitId, boolean dirty, @NotNull Optional<String> dirtyMarker) {
        this.tagName = Optional.of((Object)tagName);
        this.commitsAwayFromTag = commitsAwayFromTag;
        this.commitId = Optional.fromNullable((Object)commitId);
        this.dirty = dirty;
        this.dirtyMarker = (String)dirtyMarker.or((Object)DEFAULT_DIRTY_MARKER);
    }

    public DescribeResult(ObjectId commitId, boolean dirty, @NotNull Optional<String> dirtyMarker) {
        this.commitId = Optional.of((Object)commitId);
        this.dirty = dirty;
        this.dirtyMarker = (String)dirtyMarker.or((Object)DEFAULT_DIRTY_MARKER);
    }

    public DescribeResult(String tagName, boolean dirty) {
        this.tagName = Optional.of((Object)tagName);
        this.dirty = dirty;
        this.dirtyMarker = DEFAULT_DIRTY_MARKER;
    }

    public String toString() {
        ArrayList parts = this.abbrevZeroHidesCommitsPartOfDescribe() ? Lists.newArrayList((Object[])new String[]{this.tag(), this.dirtyMarker()}) : Lists.newArrayList((Object[])new String[]{this.tag(), this.commitsAwayFromTag(), this.prefixedCommitId(), this.dirtyMarker()});
        return Joiner.on((String)"-").skipNulls().join((Iterable)parts);
    }

    private boolean abbrevZeroHidesCommitsPartOfDescribe() {
        return this.abbrev == 0;
    }

    @Nullable
    public String commitsAwayFromTag() {
        return this.commitsAwayFromTag == 0 ? null : String.valueOf(this.commitsAwayFromTag);
    }

    @Nullable
    public String dirtyMarker() {
        return this.dirty ? this.dirtyMarker : null;
    }

    @Nullable
    public String prefixedCommitId() {
        if (this.commitId.isPresent()) {
            String fullHash = String.valueOf(((ObjectId)this.commitId.get()).getName());
            String abbrevHash = fullHash.substring(0, this.abbrev);
            if (this.tagName.isPresent()) {
                return "g" + abbrevHash;
            }
            return abbrevHash;
        }
        return null;
    }

    @Nullable
    public ObjectId commitObjectId() {
        if (this.commitId.isPresent()) {
            return (ObjectId)this.commitId.get();
        }
        return null;
    }

    @Nullable
    public String tag() {
        return (String)this.tagName.orNull();
    }
}

