/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.project13.jgit.DescribeCommand;
import pl.project13.jgit.DescribeResult;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.GitDirLocator;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MavenLoggerBridge;

public class GitCommitIdMojo
extends AbstractMojo {
    public static final String BRANCH = "branch";
    public static final String COMMIT_ID = "commit.id";
    public static final String COMMIT_ID_ABBREV = "commit.id.abbrev";
    public static final String COMMIT_DESCRIBE = "commit.id.describe";
    public static final String BUILD_AUTHOR_NAME = "build.user.name";
    public static final String BUILD_AUTHOR_EMAIL = "build.user.email";
    public static final String BUILD_TIME = "build.time";
    public static final String COMMIT_AUTHOR_NAME = "commit.user.name";
    public static final String COMMIT_AUTHOR_EMAIL = "commit.user.email";
    public static final String COMMIT_MESSAGE_FULL = "commit.message.full";
    public static final String COMMIT_MESSAGE_SHORT = "commit.message.short";
    public static final String COMMIT_TIME = "commit.time";
    MavenProject project;
    private List reactorProjects;
    private boolean verbose;
    private boolean skipPoms;
    private boolean generateGitPropertiesFile;
    private String generateGitPropertiesFilename;
    private File dotGitDirectory;
    private GitDescribeConfig gitDescribe;
    private int abbrevLength;
    private String prefix;
    private String prefixDot;
    private String dateFormat;
    private boolean failOnNoGitDirectory;
    private Properties properties;
    public final String logPrefix = "[GitCommitIdMojo] ";
    boolean runningTests = false;
    @NotNull
    LoggerBridge loggerBridge = new MavenLoggerBridge(this.getLog(), this.verbose);

    public void execute() throws MojoExecutionException {
        if (this.isPomProject(this.project) && this.skipPoms) {
            this.log("Skipping the execution as it is a project with packaging type: 'pom'", new String[0]);
            return;
        }
        this.dotGitDirectory = this.lookupGitDirectory();
        this.throwWhenRequiredDirectoryNotFound(this.dotGitDirectory, this.failOnNoGitDirectory, ".git directory could not be found! Please specify a valid [dotGitDirectory] in your pom.xml");
        if (this.dotGitDirectory == null) {
            this.log(".git directory could not be found, skipping execution", new String[0]);
            return;
        }
        this.log("Running on '%s' repository...", this.dotGitDirectory.getAbsolutePath());
        try {
            this.properties = this.initProperties();
            this.prefixDot = this.prefix + ".";
            this.loadGitData(this.properties);
            this.loadBuildTimeData(this.properties);
            this.logProperties(this.properties);
            if (this.generateGitPropertiesFile) {
                this.generatePropertiesFile(this.properties, this.generateGitPropertiesFilename);
            }
            this.appendPropertiesToMaven(this.properties);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not complete Mojo execution...", (Exception)e);
        }
        this.log("Finished running.", new String[0]);
    }

    private void appendPropertiesToMaven(@NotNull Properties properies) {
        this.log("Appending to Maven properties", new String[0]);
        if (this.project != null && this.reactorProjects != null) {
            for (MavenProject nextProj : this.reactorProjects) {
                Properties mavenProperties = nextProj.getProperties();
                this.log("Injecting Git properties to \"%s\" project", nextProj.getName());
                for (Object key : this.properties.keySet()) {
                    mavenProperties.put(key, this.properties.get(key));
                }
            }
        }
    }

    private void throwWhenRequiredDirectoryNotFound(File dotGitDirectory, Boolean required, String message) throws MojoExecutionException {
        if (required.booleanValue() && this.directoryDoesNotExits(dotGitDirectory)) {
            throw new MojoExecutionException(message);
        }
    }

    private File lookupGitDirectory() throws MojoExecutionException {
        return this.getGitDirLocator().lookupGitDirectory(this.project, this.dotGitDirectory);
    }

    @NotNull
    GitDirLocator getGitDirLocator() {
        return new GitDirLocator();
    }

    private Properties initProperties() throws MojoExecutionException {
        this.log("Initializing properties...", new String[0]);
        if (this.generateGitPropertiesFile) {
            this.log("Using clean properties...", new String[0]);
            this.properties = new Properties();
            return this.properties;
        }
        if (!this.runningTests) {
            this.log("Using maven project properties...", new String[0]);
            this.properties = this.project.getProperties();
            return this.properties;
        }
        this.properties = new Properties();
        return this.properties;
    }

    private void logProperties(@NotNull Properties properties) {
        this.log("------------------git properties loaded------------------", new String[0]);
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!this.isOurProperty(keyString)) continue;
            this.log(String.format("%s = %s", key, properties.getProperty(keyString)), new String[0]);
        }
        this.log("---------------------------------------------------------", new String[0]);
    }

    private boolean isOurProperty(@NotNull String keyString) {
        return keyString.startsWith(this.prefixDot);
    }

    void loadBuildTimeData(@NotNull Properties properties) {
        Date commitDate = new Date();
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        this.put(properties, BUILD_TIME, smf.format(commitDate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadGitData(@NotNull Properties properties) throws IOException, MojoExecutionException {
        this.log("Loading data from git repository...", new String[0]);
        Repository git = this.getGitRepository();
        ObjectReader objectReader = git.newObjectReader();
        String userName = git.getConfig().getString("user", null, "name");
        this.put(properties, BUILD_AUTHOR_NAME, userName);
        String userEmail = git.getConfig().getString("user", null, "email");
        this.put(properties, BUILD_AUTHOR_EMAIL, userEmail);
        Ref HEAD = git.getRef("HEAD");
        if (HEAD == null) {
            throw new MojoExecutionException("Could not get HEAD Ref, are you sure you've set the dotGitDirectory property of this plugin to a valid path?");
        }
        RevWalk revWalk = new RevWalk(git);
        RevCommit headCommit = revWalk.parseCommit((AnyObjectId)HEAD.getObjectId());
        revWalk.markStart(headCommit);
        try {
            String branch = git.getBranch();
            this.put(properties, BRANCH, branch);
            this.maybePutGitDescribe(properties, git);
            this.put(properties, COMMIT_ID, headCommit.getName());
            this.putAbbrevCommitId(objectReader, properties, headCommit, this.abbrevLength);
            String commitAuthor = headCommit.getAuthorIdent().getName();
            this.put(properties, COMMIT_AUTHOR_NAME, commitAuthor);
            String commitEmail = headCommit.getAuthorIdent().getEmailAddress();
            this.put(properties, COMMIT_AUTHOR_EMAIL, commitEmail);
            String fullMessage = headCommit.getFullMessage();
            this.put(properties, COMMIT_MESSAGE_FULL, fullMessage);
            String shortMessage = headCommit.getShortMessage();
            this.put(properties, COMMIT_MESSAGE_SHORT, shortMessage);
            long timeSinceEpoch = headCommit.getCommitTime();
            Date commitDate = new Date(timeSinceEpoch * 1000L);
            SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
            this.put(properties, COMMIT_TIME, smf.format(commitDate));
        }
        finally {
            revWalk.dispose();
        }
    }

    private void putAbbrevCommitId(ObjectReader objectReader, Properties properties, RevCommit headCommit, int abbrevLength) throws MojoExecutionException {
        if (abbrevLength < 2 || abbrevLength > 40) {
            throw new MojoExecutionException("Abbreviated commit id lenght must be between 2 and 40, inclusive! Was [%s]. Please fix your configuration (the <abbrevLength/> element).");
        }
        try {
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)headCommit, abbrevLength);
            this.put(properties, COMMIT_ID_ABBREV, abbreviatedObjectId.name());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to abbreviate commit id! You may want to investigate the <abbrevLength/> element in your configuration.", (Exception)e);
        }
    }

    void maybePutGitDescribe(@NotNull Properties properties, @NotNull Repository repository) throws MojoExecutionException {
        if (this.gitDescribe == null || !this.gitDescribe.isSkip()) {
            this.putGitDescribe(properties, repository);
        }
    }

    @VisibleForTesting
    void putGitDescribe(@NotNull Properties properties, @NotNull Repository repository) throws MojoExecutionException {
        try {
            DescribeResult describeResult = DescribeCommand.on(repository).withLoggerBridge(this.loggerBridge).setVerbose(this.verbose).apply(this.gitDescribe).call();
            this.put(properties, COMMIT_DESCRIBE, describeResult.toString());
        }
        catch (GitAPIException ex) {
            throw new MojoExecutionException("Unable to obtain git.commit.id.describe information", (Exception)((Object)ex));
        }
    }

    void generatePropertiesFile(@NotNull Properties properties, String generateGitPropertiesFilename) throws IOException {
        String filename = this.project.getBasedir().getAbsolutePath() + File.separatorChar + generateGitPropertiesFilename;
        FileWriter fileWriter = null;
        try {
            File gitPropsFile = new File(filename);
            Files.createParentDirs((File)gitPropsFile);
            fileWriter = new FileWriter(gitPropsFile);
            properties.store(fileWriter, "Generated by Git-Commit-Id-Plugin");
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException("Cannot create custom git properties file: " + generateGitPropertiesFilename, ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)fileWriter);
    }

    boolean isPomProject(@NotNull MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }

    @NotNull
    private Repository getGitRepository() throws MojoExecutionException {
        FileRepository repository;
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.setGitDir(this.dotGitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize repository...", (Exception)e);
        }
        if (repository == null) {
            throw new MojoExecutionException("Could not create git repository. Are you sure '" + this.dotGitDirectory + "' is the valid Git root for your project?");
        }
        return repository;
    }

    private void put(@NotNull Properties properties, String key, String value) {
        this.putWithoutPrefix(properties, this.prefixDot + key, value);
    }

    private void putWithoutPrefix(@NotNull Properties properties, String key, String value) {
        if (this.verbose) {
            String s = String.format("Storing: %s = %s", key, value);
            this.log(s, new String[0]);
        }
        if (this.isNotEmpty(value)) {
            properties.put(key, value);
        } else {
            properties.put(key, "Unknown");
        }
    }

    private boolean isNotEmpty(@Nullable String value) {
        return null != value && !" ".equals(value.trim().replaceAll(" ", ""));
    }

    void log(String message, String ... interpolations) {
        this.loggerBridge.log("[GitCommitIdMojo] " + message, interpolations);
    }

    private boolean directoryExists(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }

    private boolean directoryDoesNotExits(File fileLocation) {
        return !this.directoryExists(fileLocation);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDotGitDirectory(File dotGitDirectory) {
        this.dotGitDirectory = dotGitDirectory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
    }

    public void setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
    }
}

