/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class HudsonJenkinsBuildServerData
extends BuildServerDataProvider {
    HudsonJenkinsBuildServerData(@Nonnull LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(@Nonnull Map<String, String> env) {
        return env.containsKey("JENKINS_URL") || env.containsKey("JENKINS_HOME") || env.containsKey("HUDSON_URL") || env.containsKey("HUDSON_HOME");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = this.env.getOrDefault("BUILD_NUMBER", "");
        this.maybePut(properties, "build.number", () -> buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedLocalBranch = (String)this.env.get("GIT_LOCAL_BRANCH");
        if (environmentBasedLocalBranch != null && !environmentBasedLocalBranch.isEmpty()) {
            this.log.info("Using environment variable based branch name. GIT_LOCAL_BRANCH = {}", (Object)environmentBasedLocalBranch);
            return environmentBasedLocalBranch;
        }
        String environmentBasedBranch = (String)this.env.get("GIT_BRANCH");
        this.log.info("Using environment variable based branch name. GIT_BRANCH = {}", (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

