/*
 * Decompiled with CFR 0.152.
 */
package pl.tlinkowski.unij.service.collect.jdk8;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.NonNull;
import pl.tlinkowski.annotation.basic.NullOr;
import pl.tlinkowski.unij.service.api.UniJService;
import pl.tlinkowski.unij.service.api.collect.UnmodifiableMapFactory;

@UniJService(priority=40)
public final class Jdk8UnmodifiableMapFactory
implements UnmodifiableMapFactory {
    private static final Map<Object, Object> EMPTY_MAP = new Builder(0).build();

    public <T, K, V> Collector<T, ?, Map<K, V>> collector(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper), this::ofTrustedHashMap);
    }

    public <T, K, V> Collector<T, ?, Map<K, V>> collector(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, mergeFunction), this::ofTrustedHashMap);
    }

    public <K, V> Map<K, V> copyOf(Map<? extends K, ? extends V> map) {
        return this.ofTrustedHashMap(new HashMap<K, V>(map));
    }

    @SafeVarargs
    public final <K, V> Map<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        switch (entries.length) {
            case 0: {
                return this.of();
            }
            case 1: {
                Map.Entry<K, V> entry = entries[0];
                return this.of(entry.getKey(), entry.getValue());
            }
        }
        return this.ofAtLeastTwoEntries(entries);
    }

    public <K, V> Map.Entry<K, V> entry(@NonNull K k, @NonNull V v) {
        if (k == null) {
            throw new NullPointerException("k is marked non-null but is null");
        }
        if (v == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    public <K, V> Map<K, V> of() {
        return EMPTY_MAP;
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        return Collections.singletonMap(k1, v1);
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        return new Builder<K, V>(2).put(k1, v1).put(k2, v2).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        return new Builder<K, V>(3).put(k1, v1).put(k2, v2).put(k3, v3).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3, @NonNull K k4, @NonNull V v4) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        if (k4 == null) {
            throw new NullPointerException("k4 is marked non-null but is null");
        }
        if (v4 == null) {
            throw new NullPointerException("v4 is marked non-null but is null");
        }
        return new Builder<K, V>(4).put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3, @NonNull K k4, @NonNull V v4, @NonNull K k5, @NonNull V v5) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        if (k4 == null) {
            throw new NullPointerException("k4 is marked non-null but is null");
        }
        if (v4 == null) {
            throw new NullPointerException("v4 is marked non-null but is null");
        }
        if (k5 == null) {
            throw new NullPointerException("k5 is marked non-null but is null");
        }
        if (v5 == null) {
            throw new NullPointerException("v5 is marked non-null but is null");
        }
        return new Builder<K, V>(5).put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3, @NonNull K k4, @NonNull V v4, @NonNull K k5, @NonNull V v5, @NonNull K k6, @NonNull V v6) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        if (k4 == null) {
            throw new NullPointerException("k4 is marked non-null but is null");
        }
        if (v4 == null) {
            throw new NullPointerException("v4 is marked non-null but is null");
        }
        if (k5 == null) {
            throw new NullPointerException("k5 is marked non-null but is null");
        }
        if (v5 == null) {
            throw new NullPointerException("v5 is marked non-null but is null");
        }
        if (k6 == null) {
            throw new NullPointerException("k6 is marked non-null but is null");
        }
        if (v6 == null) {
            throw new NullPointerException("v6 is marked non-null but is null");
        }
        return new Builder<K, V>(6).put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).put(k6, v6).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3, @NonNull K k4, @NonNull V v4, @NonNull K k5, @NonNull V v5, @NonNull K k6, @NonNull V v6, @NonNull K k7, @NonNull V v7) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        if (k4 == null) {
            throw new NullPointerException("k4 is marked non-null but is null");
        }
        if (v4 == null) {
            throw new NullPointerException("v4 is marked non-null but is null");
        }
        if (k5 == null) {
            throw new NullPointerException("k5 is marked non-null but is null");
        }
        if (v5 == null) {
            throw new NullPointerException("v5 is marked non-null but is null");
        }
        if (k6 == null) {
            throw new NullPointerException("k6 is marked non-null but is null");
        }
        if (v6 == null) {
            throw new NullPointerException("v6 is marked non-null but is null");
        }
        if (k7 == null) {
            throw new NullPointerException("k7 is marked non-null but is null");
        }
        if (v7 == null) {
            throw new NullPointerException("v7 is marked non-null but is null");
        }
        return new Builder<K, V>(7).put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).put(k6, v6).put(k7, v7).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3, @NonNull K k4, @NonNull V v4, @NonNull K k5, @NonNull V v5, @NonNull K k6, @NonNull V v6, @NonNull K k7, @NonNull V v7, @NonNull K k8, @NonNull V v8) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        if (k4 == null) {
            throw new NullPointerException("k4 is marked non-null but is null");
        }
        if (v4 == null) {
            throw new NullPointerException("v4 is marked non-null but is null");
        }
        if (k5 == null) {
            throw new NullPointerException("k5 is marked non-null but is null");
        }
        if (v5 == null) {
            throw new NullPointerException("v5 is marked non-null but is null");
        }
        if (k6 == null) {
            throw new NullPointerException("k6 is marked non-null but is null");
        }
        if (v6 == null) {
            throw new NullPointerException("v6 is marked non-null but is null");
        }
        if (k7 == null) {
            throw new NullPointerException("k7 is marked non-null but is null");
        }
        if (v7 == null) {
            throw new NullPointerException("v7 is marked non-null but is null");
        }
        if (k8 == null) {
            throw new NullPointerException("k8 is marked non-null but is null");
        }
        if (v8 == null) {
            throw new NullPointerException("v8 is marked non-null but is null");
        }
        return new Builder<K, V>(8).put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).put(k6, v6).put(k7, v7).put(k8, v8).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3, @NonNull K k4, @NonNull V v4, @NonNull K k5, @NonNull V v5, @NonNull K k6, @NonNull V v6, @NonNull K k7, @NonNull V v7, @NonNull K k8, @NonNull V v8, @NonNull K k9, @NonNull V v9) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        if (k4 == null) {
            throw new NullPointerException("k4 is marked non-null but is null");
        }
        if (v4 == null) {
            throw new NullPointerException("v4 is marked non-null but is null");
        }
        if (k5 == null) {
            throw new NullPointerException("k5 is marked non-null but is null");
        }
        if (v5 == null) {
            throw new NullPointerException("v5 is marked non-null but is null");
        }
        if (k6 == null) {
            throw new NullPointerException("k6 is marked non-null but is null");
        }
        if (v6 == null) {
            throw new NullPointerException("v6 is marked non-null but is null");
        }
        if (k7 == null) {
            throw new NullPointerException("k7 is marked non-null but is null");
        }
        if (v7 == null) {
            throw new NullPointerException("v7 is marked non-null but is null");
        }
        if (k8 == null) {
            throw new NullPointerException("k8 is marked non-null but is null");
        }
        if (v8 == null) {
            throw new NullPointerException("v8 is marked non-null but is null");
        }
        if (k9 == null) {
            throw new NullPointerException("k9 is marked non-null but is null");
        }
        if (v9 == null) {
            throw new NullPointerException("v9 is marked non-null but is null");
        }
        return new Builder<K, V>(9).put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).put(k6, v6).put(k7, v7).put(k8, v8).put(k9, v9).build();
    }

    public <K, V> Map<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2, @NonNull K k3, @NonNull V v3, @NonNull K k4, @NonNull V v4, @NonNull K k5, @NonNull V v5, @NonNull K k6, @NonNull V v6, @NonNull K k7, @NonNull V v7, @NonNull K k8, @NonNull V v8, @NonNull K k9, @NonNull V v9, @NonNull K k10, @NonNull V v10) {
        if (k1 == null) {
            throw new NullPointerException("k1 is marked non-null but is null");
        }
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        if (k2 == null) {
            throw new NullPointerException("k2 is marked non-null but is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        if (k3 == null) {
            throw new NullPointerException("k3 is marked non-null but is null");
        }
        if (v3 == null) {
            throw new NullPointerException("v3 is marked non-null but is null");
        }
        if (k4 == null) {
            throw new NullPointerException("k4 is marked non-null but is null");
        }
        if (v4 == null) {
            throw new NullPointerException("v4 is marked non-null but is null");
        }
        if (k5 == null) {
            throw new NullPointerException("k5 is marked non-null but is null");
        }
        if (v5 == null) {
            throw new NullPointerException("v5 is marked non-null but is null");
        }
        if (k6 == null) {
            throw new NullPointerException("k6 is marked non-null but is null");
        }
        if (v6 == null) {
            throw new NullPointerException("v6 is marked non-null but is null");
        }
        if (k7 == null) {
            throw new NullPointerException("k7 is marked non-null but is null");
        }
        if (v7 == null) {
            throw new NullPointerException("v7 is marked non-null but is null");
        }
        if (k8 == null) {
            throw new NullPointerException("k8 is marked non-null but is null");
        }
        if (v8 == null) {
            throw new NullPointerException("v8 is marked non-null but is null");
        }
        if (k9 == null) {
            throw new NullPointerException("k9 is marked non-null but is null");
        }
        if (v9 == null) {
            throw new NullPointerException("v9 is marked non-null but is null");
        }
        if (k10 == null) {
            throw new NullPointerException("k10 is marked non-null but is null");
        }
        if (v10 == null) {
            throw new NullPointerException("v10 is marked non-null but is null");
        }
        return new Builder<K, V>(10).put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).put(k6, v6).put(k7, v7).put(k8, v8).put(k9, v9).put(k10, v10).build();
    }

    private <K, V> Map<K, V> ofTrustedHashMap(Map<K, V> map) {
        switch (map.size()) {
            case 0: {
                return this.of();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return this.of(entry.getKey(), entry.getValue());
            }
        }
        map.forEach((key, value) -> {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
        });
        return Collections.unmodifiableMap((HashMap)map);
    }

    private <K, V> Map<K, V> ofAtLeastTwoEntries(Map.Entry<? extends K, ? extends V>[] entries) {
        Builder<K, V> builder = new Builder<K, V>(entries.length);
        for (Map.Entry<K, V> entry : entries) {
            builder.putWithNullChecks(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private static class Builder<K, V> {
        private final Map<K, V> map;

        Builder(int size) {
            this.map = new HashMap((int)((double)size / 0.75));
        }

        Builder<K, V> putWithNullChecks(@NonNull K key, @NonNull V value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.put(key, value);
        }

        Builder<K, V> put(K key, V value) {
            @NullOr V prevValue = this.map.put(key, value);
            if (prevValue != null) {
                throw new IllegalArgumentException(String.format("Duplicate key: %s (attempted merging values %s and %s)", key, prevValue, value));
            }
            return this;
        }

        Map<K, V> build() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

