/*
 * Decompiled with CFR 0.152.
 */
package pl.tlinkowski.unij.service.misc.jdk8;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import pl.tlinkowski.unij.service.api.UniJService;
import pl.tlinkowski.unij.service.api.misc.MiscellaneousApiProvider;

@UniJService(priority=40)
public final class Jdk8MiscellaneousApiProvider
implements MiscellaneousApiProvider {
    public <T, U, A, R> Collector<T, ?, R> flatMappingCollector(Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        BiConsumer accumulator = downstream.accumulator();
        BiConsumer<Object, Object> newAccumulator = (a, t) -> {
            try (Stream mappedStream = (Stream)mapper.apply(t);){
                if (mappedStream != null) {
                    ((Stream)mappedStream.sequential()).forEach(u -> accumulator.accept(a, u));
                }
            }
        };
        return this.collectorWithNewAccumulator(downstream, newAccumulator);
    }

    public <T, A, R> Collector<T, ?, R> filteringCollector(Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
        BiConsumer accumulator = downstream.accumulator();
        BiConsumer<Object, Object> newAccumulator = (a, t) -> {
            if (predicate.test(t)) {
                accumulator.accept(a, t);
            }
        };
        return this.collectorWithNewAccumulator(downstream, newAccumulator);
    }

    private <T, A, R> Collector<T, ?, R> collectorWithNewAccumulator(Collector<?, A, R> collector, BiConsumer<A, T> newAccumulator) {
        return Collector.of(collector.supplier(), newAccumulator, collector.combiner(), collector.finisher(), collector.characteristics().toArray(new Collector.Characteristics[0]));
    }
}

