/*
 * Decompiled with CFR 0.152.
 */
package ru.concerteza.util.buildnumber;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import ru.concerteza.util.buildnumber.BuildNumber;

public class BuildNumberExtractor {
    private static final String EMPTY_STRING = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildNumber extract(File repoDirectory) throws IOException {
        if (!repoDirectory.exists() || !repoDirectory.isDirectory()) {
            throw new IOException("Invalid repository directory provided: " + repoDirectory.getAbsolutePath());
        }
        File canonicalRepo = repoDirectory.getCanonicalFile();
        FileRepository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(canonicalRepo)).build();
        try {
            ObjectId revisionObject = repo.resolve("HEAD");
            if (null == revisionObject) {
                throw new IOException("Cannot read current revision from repository: " + repo);
            }
            String revision = revisionObject.name();
            String branch = BuildNumberExtractor.readCurrentBranch(repo, revision);
            String tag = BuildNumberExtractor.readCurrentTag(repo, revision);
            String parent = BuildNumberExtractor.readCurrentParent(repo, revision);
            int commitsCount = BuildNumberExtractor.countCommits(repo, revisionObject);
            String commitDate = BuildNumberExtractor.readCurrentCommitDate(repo, revision);
            BuildNumber buildNumber = new BuildNumber(revision, branch, tag, parent, commitsCount, commitDate);
            return buildNumber;
        }
        finally {
            repo.close();
        }
    }

    private static String readCurrentBranch(FileRepository repo, String revision) throws IOException {
        String branch = repo.getBranch();
        if (null == branch) {
            return EMPTY_STRING;
        }
        if (revision.equals(branch)) {
            return EMPTY_STRING;
        }
        return branch;
    }

    private static String readCurrentTag(FileRepository repo, String revision) {
        Map<String, String> tagMap = BuildNumberExtractor.loadTagsMap(repo);
        String tag = tagMap.get(revision);
        if (null == tag) {
            return EMPTY_STRING;
        }
        return tag;
    }

    private static String readCurrentParent(FileRepository repo, String revision) throws IOException {
        ObjectId rev = repo.resolve(revision);
        if (null == rev) {
            return EMPTY_STRING;
        }
        RevWalk rw = new RevWalk((Repository)repo);
        RevCommit commit = rw.parseCommit((AnyObjectId)rev);
        RevCommit[] parents = commit.getParents();
        if (null == parents || parents.length == 0) {
            return EMPTY_STRING;
        }
        rw.dispose();
        String parentsFormat = null;
        for (RevCommit p : parents) {
            String sha1 = p.getId().name();
            parentsFormat = null == parentsFormat ? sha1 : parentsFormat + ";" + sha1;
        }
        return parentsFormat;
    }

    private static String readCurrentCommitDate(FileRepository repo, String revision) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        ObjectId rev = repo.resolve(revision);
        if (null == rev) {
            return EMPTY_STRING;
        }
        RevWalk rw = new RevWalk((Repository)repo);
        RevCommit commit = rw.parseCommit((AnyObjectId)rev);
        PersonIdent author = commit.getAuthorIdent();
        Date commitDate = author.getWhen();
        return df.format(commitDate);
    }

    private static Map<String, String> loadTagsMap(FileRepository repo) {
        Map refMap = repo.getTags();
        HashMap<String, String> res = new HashMap<String, String>(refMap.size());
        for (Map.Entry en : refMap.entrySet()) {
            String sha1 = BuildNumberExtractor.extractPeeledSha1(repo, (Ref)en.getValue());
            String existed = (String)res.get(sha1);
            String value = null == existed ? (String)en.getKey() : existed + ";" + (String)en.getKey();
            res.put(sha1, value);
        }
        return res;
    }

    private static String extractPeeledSha1(FileRepository repo, Ref ref) {
        Ref peeled = repo.peel(ref);
        ObjectId oid = peeled.getPeeledObjectId();
        return null != oid ? oid.name() : peeled.getObjectId().name();
    }

    private static int countCommits(FileRepository repo, ObjectId revision) throws IOException {
        RevWalk walk = new RevWalk((Repository)repo);
        walk.setRetainBody(false);
        RevCommit head = walk.parseCommit((AnyObjectId)revision);
        walk.markStart(head);
        int res = 0;
        for (RevCommit commit : walk) {
            ++res;
        }
        walk.dispose();
        return res;
    }
}

