/*
 * Decompiled with CFR 0.152.
 */
package ru.concerteza.util.buildnumber;

public class BuildNumber {
    private final String revision;
    private final String branch;
    private final String tag;
    private final int commitsCount;

    public BuildNumber(String revision, String branch, String tag, int commitsCount) {
        this.revision = revision;
        this.branch = branch;
        this.tag = tag;
        this.commitsCount = commitsCount;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getShortRevision() {
        if (null == this.revision) {
            return null;
        }
        if (this.revision.length() > 7) {
            return this.revision.substring(0, 7);
        }
        return this.revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTag() {
        return this.tag;
    }

    public int getCommitsCount() {
        return this.commitsCount;
    }

    public String getCommitsCountAsString() {
        return Integer.toString(this.commitsCount);
    }

    public String defaultBuildnumber() {
        String name = this.tag.length() > 0 ? this.tag : (this.branch.length() > 0 ? this.branch : "UNNAMED");
        return String.format("%s.%d.%s", name, this.commitsCount, this.getShortRevision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JGitBuildNumber");
        sb.append("{revision='").append(this.revision).append('\'');
        sb.append(", branch='").append(this.branch).append('\'');
        sb.append(", tag='").append(this.tag).append('\'');
        sb.append(", commitsCount=").append(this.commitsCount);
        sb.append('}');
        return sb.toString();
    }
}

