/*
 * Decompiled with CFR 0.152.
 */
package ru.finnetrolle.businesslogicvalidation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.finnetrolle.businesslogicvalidation.Rule;
import ru.finnetrolle.businesslogicvalidation.dto.ValidationResult;
import ru.finnetrolle.businesslogicvalidation.dto.Violation;
import ru.finnetrolle.businesslogicvalidation.dto.ViolationLevel;

public class ValidationEngine<V> {
    private List<Rule<V, ?>> rules = new ArrayList();

    private ValidationEngine() {
    }

    public static <V> ValidationEngine<V> create() {
        return new ValidationEngine<V>();
    }

    @SafeVarargs
    public static <V> ValidationEngine<V> create(Rule<V, ?> ... rules) {
        ValidationEngine<V> engine = new ValidationEngine<V>();
        for (Rule<V, ?> rule : rules) {
            engine.addRule(rule);
        }
        return engine;
    }

    public ValidationEngine<V> addRule(Rule<V, ?> rule) {
        this.rules.add(rule);
        return this;
    }

    private List<Violation> getViolations(V value) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (Rule<V, ?> rule : this.rules) {
            Violation violation = rule.check(value);
            if (violation == null) continue;
            violations.add(violation);
            if (violation.getViolationLevel() != ViolationLevel.CRITICAL) continue;
            break;
        }
        return violations;
    }

    public ValidationResult validate(V value) {
        return ValidationResult.create(this.getViolations(value));
    }

    public ValidationResult validate(Collection<V> values) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (V value : values) {
            violations.addAll(this.getViolations(value));
        }
        return ValidationResult.create(violations);
    }
}

