/*
 * Decompiled with CFR 0.152.
 */
package ru.finnetrolle.businesslogicvalidation.dto;

import java.util.List;
import java.util.Objects;
import ru.finnetrolle.businesslogicvalidation.dto.Violation;
import ru.finnetrolle.businesslogicvalidation.dto.ViolationLevel;

public class ValidationResult {
    private final List<Violation> violations;
    private final ViolationLevel level;

    private ValidationResult(List<Violation> violations) {
        ViolationLevel level = ViolationLevel.NOTICE;
        for (Violation violation : violations) {
            if (violation.getViolationLevel().compareTo(level) <= 0) continue;
            level = violation.getViolationLevel();
        }
        this.violations = violations;
        this.level = level;
    }

    public static ValidationResult create(List<Violation> violations) {
        return new ValidationResult(violations);
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public ViolationLevel getLevel() {
        return this.level;
    }

    public boolean passed() {
        return this.level == ViolationLevel.NOTICE || this.level == ViolationLevel.PERMISSIBLE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult result = (ValidationResult)o;
        return Objects.equals(this.violations, result.violations) && this.level == result.level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.violations, this.level});
    }

    public String toString() {
        return "ValidationResult {level = " + (Object)((Object)this.level) + "\nviolations=" + this.violations + '}';
    }
}

