/*
 * Decompiled with CFR 0.152.
 */
package ru.finnetrolle.businesslogicvalidation.dto;

import java.util.Objects;
import ru.finnetrolle.businesslogicvalidation.dto.ViolationLevel;

public class Violation {
    private final String name;
    private final String message;
    private final Integer code;
    private final ViolationLevel violationLevel;

    private Violation(String name, String message, Integer code, ViolationLevel violationLevel) {
        this.name = name;
        this.message = message;
        this.code = code;
        this.violationLevel = violationLevel;
    }

    public static Violation create(String name, String message, Integer code, ViolationLevel violationLevel) {
        return new Violation(name, message, code, violationLevel);
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public ViolationLevel getViolationLevel() {
        return this.violationLevel;
    }

    public String toString() {
        return "Violation{name='" + this.name + '\'' + ", message='" + this.message + '\'' + ", code=" + this.code + ", violationLevel=" + (Object)((Object)this.violationLevel) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Violation)) {
            return false;
        }
        Violation violation = (Violation)o;
        return Objects.equals(this.name, violation.name) && Objects.equals(this.message, violation.message) && Objects.equals(this.code, violation.code) && this.violationLevel == violation.violationLevel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.message, this.code, this.violationLevel});
    }
}

