/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TimeZone;
import org.apache.http.entity.AbstractHttpEntity;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.ClickHouseRowBinaryStream;
import ru.yandex.clickhouse.util.ClickHouseStreamCallback;

public class ClickHouseStreamHttpEntity
extends AbstractHttpEntity {
    private final ClickHouseStreamCallback callback;
    private final TimeZone timeZone;
    private final ClickHouseProperties properties;

    public ClickHouseStreamHttpEntity(ClickHouseStreamCallback callback, TimeZone timeZone, ClickHouseProperties properties) {
        Preconditions.checkNotNull((Object)callback);
        this.timeZone = timeZone;
        this.callback = callback;
        this.properties = properties;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return -1L;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return null;
    }

    public void writeTo(OutputStream out) throws IOException {
        ClickHouseRowBinaryStream stream = new ClickHouseRowBinaryStream(out, this.timeZone, this.properties);
        this.callback.writeTo(stream);
    }

    public boolean isStreaming() {
        return false;
    }
}

