/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import ru.yandex.clickhouse.jdbcbridge.core.ByteBuffer;
import ru.yandex.clickhouse.jdbcbridge.core.ColumnDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.core.Extension;
import ru.yandex.clickhouse.jdbcbridge.core.ExtensionManager;
import ru.yandex.clickhouse.jdbcbridge.core.NamedDataSource;
import ru.yandex.clickhouse.jdbcbridge.core.NamedQuery;
import ru.yandex.clickhouse.jdbcbridge.core.NamedSchema;
import ru.yandex.clickhouse.jdbcbridge.core.QueryParameters;
import ru.yandex.clickhouse.jdbcbridge.core.QueryParser;
import ru.yandex.clickhouse.jdbcbridge.core.Repository;
import ru.yandex.clickhouse.jdbcbridge.core.RepositoryManager;
import ru.yandex.clickhouse.jdbcbridge.core.ResponseWriter;
import ru.yandex.clickhouse.jdbcbridge.core.TableDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;
import ru.yandex.clickhouse.jdbcbridge.impl.ConfigDataSource;
import ru.yandex.clickhouse.jdbcbridge.impl.JdbcDataSource;
import ru.yandex.clickhouse.jdbcbridge.impl.JsonFileRepository;
import ru.yandex.clickhouse.jdbcbridge.impl.ScriptDataSource;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.system.ProcessorMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.system.UptimeMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.ConfigRetriever;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.ConfigRetrieverOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.ConfigStoreOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AbstractVerticle;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Router;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.RoutingContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.BodyHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.ResponseContentTypeHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.TimeoutHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MicrometerMetricsOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.PrometheusScrapingHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.VertxPrometheusOptions;

public class JdbcBridgeVerticle
extends AbstractVerticle
implements ExtensionManager {
    private static final Logger log = LoggerFactory.getLogger(JdbcBridgeVerticle.class);
    private static volatile long startTime;
    private static final String CONFIG_PATH;
    private static final int DEFAULT_SERVER_PORT = 9019;
    private static final String RESPONSE_CONTENT_TYPE = "application/octet-stream";
    private static final String WRITE_RESPONSE = "Ok.";
    private static final String PING_RESPONSE = "Ok.\n";
    private final List<Extension<?>> extensions = new ArrayList();
    private final RepositoryManager repos = Utils.loadService(RepositoryManager.class);
    private long scanInterval = 5000L;

    List<Repository<?>> loadRepositories(JsonObject serverConfig) {
        JsonArray declaredRepos;
        ArrayList repos = new ArrayList();
        Extension<JsonFileRepository> defaultExt = new Extension<JsonFileRepository>(JsonFileRepository.class);
        JsonArray jsonArray = declaredRepos = serverConfig == null ? null : serverConfig.getJsonArray("repositories");
        if (declaredRepos == null) {
            declaredRepos = new JsonArray();
            declaredRepos.add(NamedDataSource.class.getName());
            declaredRepos.add(NamedSchema.class.getName());
            declaredRepos.add(NamedQuery.class.getName());
        }
        for (Object item : declaredRepos) {
            Repository repo = null;
            if (item instanceof String) {
                repo = defaultExt.newInstance(this, defaultExt.loadClass(String.valueOf(item)));
            } else {
                Extension<?> ext;
                JsonObject o = (JsonObject)item;
                String entityClassName = o.getString("entity");
                if (entityClassName == null || entityClassName.isEmpty()) continue;
                String repoClassName = o.getString("repository");
                ArrayList<String> urls = null;
                JsonArray libUrls = o.getJsonArray("libUrls");
                if (repoClassName != null && !repoClassName.isEmpty() && libUrls != null) {
                    urls = new ArrayList<String>(libUrls.size());
                    for (Object u : libUrls) {
                        if (!(u instanceof String)) continue;
                        urls.add((String)u);
                    }
                }
                if ((ext = Utils.loadExtension(urls, repoClassName)) != null) {
                    repo = (Repository)ext.newInstance(this, ext.loadClass(entityClassName));
                }
            }
            if (repo == null) continue;
            repos.add(repo);
        }
        return repos;
    }

    List<Extension<?>> loadExtensions(JsonObject serverConfig) {
        JsonArray declaredExts;
        ArrayList exts = new ArrayList();
        JsonArray jsonArray = declaredExts = serverConfig == null ? null : serverConfig.getJsonArray("extensions");
        if (declaredExts == null) {
            declaredExts = new JsonArray();
            declaredExts.add(JdbcDataSource.class.getName());
            declaredExts.add(ConfigDataSource.class.getName());
            declaredExts.add(ScriptDataSource.class.getName());
        }
        for (Object item : declaredExts) {
            Extension<?> ext = null;
            if (item instanceof String) {
                ext = Utils.loadExtension((String)item);
            } else {
                JsonObject o = (JsonObject)item;
                String className = o.getString("class");
                JsonArray libUrls = o.getJsonArray("libUrls");
                if (libUrls != null) {
                    ArrayList<String> urls = new ArrayList<String>(libUrls.size());
                    for (Object u : libUrls) {
                        if (!(u instanceof String)) continue;
                        urls.add((String)u);
                    }
                    ext = Utils.loadExtension(urls, className);
                } else {
                    ext = Utils.loadExtension(className);
                }
            }
            if (ext == null) continue;
            exts.add(ext);
        }
        return exts;
    }

    @Override
    public void start() {
        JsonObject config = Utils.loadJsonFromFile(Paths.get(CONFIG_PATH, Utils.getConfiguration("server.json", "SERVER_CONFIG_FILE", "jdbc-bridge.server.config.file")).toString());
        this.scanInterval = config.getLong("configScanPeriod", 5000L);
        this.repos.update(this.loadRepositories(config));
        this.extensions.addAll(this.loadExtensions(config));
        for (Extension<?> ext : this.extensions) {
            ext.initialize(this);
        }
        this.startServer(config, Utils.loadJsonFromFile(Paths.get(CONFIG_PATH, Utils.getConfiguration("httpd.json", "HTTPD_CONFIG_FILE", "jdbc-bridge.httpd.config.file")).toString()));
    }

    private void startServer(JsonObject bridgeServerConfig, JsonObject httpServerConfig) {
        if (httpServerConfig.isEmpty()) {
            httpServerConfig.put("maxInitialLineLength", (Long)Integer.MAX_VALUE);
        }
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions(httpServerConfig));
        long requestTimeout = bridgeServerConfig.getLong("requestTimeout", 5000L);
        long queryTimeout = Math.max(requestTimeout, bridgeServerConfig.getLong("queryTimeout", 30000L));
        TimeoutHandler requestTimeoutHandler = TimeoutHandler.create(requestTimeout);
        TimeoutHandler queryTimeoutHandler = TimeoutHandler.create(queryTimeout);
        Router router = Router.router(this.vertx);
        router.route("/metrics").handler(PrometheusScrapingHandler.create());
        router.route().handler(BodyHandler.create()).handler(this::responseHandlers).handler(ResponseContentTypeHandler.create()).failureHandler(this::errorHandler);
        router.get("/ping").handler(requestTimeoutHandler).handler(this::handlePing);
        router.post("/identifier_quote").produces(RESPONSE_CONTENT_TYPE).handler(requestTimeoutHandler).handler(this::handleIdentifierQuote);
        router.post("/columns_info").produces(RESPONSE_CONTENT_TYPE).handler(queryTimeoutHandler).handler(this::handleColumnsInfo);
        router.post("/").produces(RESPONSE_CONTENT_TYPE).handler(queryTimeoutHandler).handler(this::handleQuery);
        router.post("/write").produces(RESPONSE_CONTENT_TYPE).handler(queryTimeoutHandler).handler(this::handleWrite);
        log.info("Starting web server...");
        int port = bridgeServerConfig.getInteger("serverPort", 9019);
        server.requestHandler(router).listen(port, action -> {
            if (action.succeeded()) {
                log.info("Server http://0.0.0.0:{} started in {} ms", (Object)port, (Object)(System.currentTimeMillis() - startTime));
            } else {
                log.error("Failed to start server", action.cause());
            }
        });
    }

    private void responseHandlers(RoutingContext ctx) {
        HttpServerRequest req = ctx.request();
        String path = ctx.normalisedPath();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Context:\n{}", (Object)path, (Object)ctx.data());
            log.debug("[{}] Headers:\n{}", (Object)path, (Object)req.headers());
            log.debug("[{}] Parameters:\n{}", (Object)path, (Object)req.params());
        }
        if (log.isTraceEnabled()) {
            log.trace("[{}] Body:\n{}", (Object)path, (Object)ctx.getBodyAsString());
        }
        HttpServerResponse resp = ctx.response();
        resp.endHandler(handler -> {
            if (log.isTraceEnabled()) {
                log.trace("[{}] About to end response...", (Object)ctx.normalisedPath());
            }
        });
        resp.closeHandler(handler -> {
            if (log.isTraceEnabled()) {
                log.trace("[{}] About to close response...", (Object)ctx.normalisedPath());
            }
        });
        resp.drainHandler(handler -> {
            if (log.isTraceEnabled()) {
                log.trace("[{}] About to drain response...", (Object)ctx.normalisedPath());
            }
        });
        resp.exceptionHandler(throwable -> log.error("Caught exception", (Throwable)throwable));
        ctx.next();
    }

    private void errorHandler(RoutingContext ctx) {
        log.error("Failed to respond", ctx.failure());
        ctx.response().setStatusCode(500).end(ctx.failure().getMessage());
    }

    private void handlePing(RoutingContext ctx) {
        ctx.response().end(PING_RESPONSE);
    }

    private NamedDataSource getDataSource(String uri, boolean orCreate) {
        return this.getDataSource(this.getDataSourceRepository(), uri, orCreate);
    }

    private NamedDataSource getDataSource(Repository<NamedDataSource> repo, String uri, boolean orCreate) {
        NamedDataSource ds = repo.get(uri);
        return ds == null && orCreate ? new NamedDataSource(uri, null, null) : ds;
    }

    private void handleColumnsInfo(RoutingContext ctx) {
        QueryParser parser = QueryParser.fromRequest(ctx, this.getDataSourceRepository());
        TableDefinition tableDef = null;
        String rawSchema = parser.getRawSchema();
        NamedSchema namedSchema = this.getSchemaRepository().get(rawSchema);
        if (namedSchema == null) {
            String schema = parser.getNormalizedSchema();
            if (schema.indexOf(32) != -1) {
                if (log.isDebugEnabled()) {
                    log.debug("Got inline schema:\n[{}]", (Object)schema);
                }
                tableDef = TableDefinition.fromString(schema);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Got named schema:\n[{}]", (Object)namedSchema);
            }
            tableDef = namedSchema.getColumns();
        }
        String rawQuery = parser.getRawQuery();
        log.info("Raw query:\n{}", (Object)rawQuery);
        String uri = parser.getConnectionString();
        QueryParameters params = parser.getQueryParameters();
        NamedDataSource ds = this.getDataSource(uri, params.isDebug());
        String dsId = uri;
        if (ds != null) {
            dsId = ds.getId();
            params = ds.newQueryParameters(params);
        }
        if (tableDef == null) {
            NamedQuery namedQuery = this.getQueryRepository().get(rawQuery);
            if (namedQuery != null) {
                if (namedSchema == null) {
                    namedSchema = this.getSchemaRepository().get(namedQuery.getSchema());
                }
                tableDef = namedSchema != null ? namedSchema.getColumns() : namedQuery.getColumns();
            } else {
                tableDef = namedSchema != null ? namedSchema.getColumns() : ds.getResultColumns(rawSchema, parser.getNormalizedQuery(), params);
            }
        }
        ArrayList<ColumnDefinition> additionalColumns = new ArrayList<ColumnDefinition>();
        if (params.showDatasourceColumn()) {
            additionalColumns.add(new ColumnDefinition("datasource", DataType.Str, true, 0, 0, 0, null, dsId, null));
        }
        if (params.showCustomColumns() && ds != null) {
            additionalColumns.addAll(ds.getCustomColumns());
        }
        if (additionalColumns.size() > 0) {
            tableDef = new TableDefinition(tableDef, true, additionalColumns.toArray(new ColumnDefinition[additionalColumns.size()]));
        }
        String columnsInfo = tableDef.toString();
        if (log.isDebugEnabled()) {
            log.debug("Columns info:\n[{}]", (Object)columnsInfo);
        }
        ctx.response().end(ByteBuffer.asBuffer(columnsInfo));
    }

    private void handleIdentifierQuote(RoutingContext ctx) {
        ctx.response().end(ByteBuffer.asBuffer("`"));
    }

    private void handleQuery(RoutingContext ctx) {
        Repository<NamedDataSource> manager = this.getDataSourceRepository();
        QueryParser parser = QueryParser.fromRequest(ctx, manager);
        ctx.response().setChunked(true);
        this.vertx.executeBlocking(promise -> {
            if (log.isTraceEnabled()) {
                log.trace("About to execute query...");
            }
            QueryParameters params = parser.getQueryParameters();
            NamedDataSource ds = this.getDataSource(manager, parser.getConnectionString(), params.isDebug());
            params = ds.newQueryParameters(params);
            String rawSchema = parser.getRawSchema();
            NamedSchema namedSchema = this.getSchemaRepository().get(rawSchema);
            String generatedQuery = parser.getRawQuery();
            String normalizedQuery = parser.getNormalizedQuery();
            NamedQuery namedQuery = this.getQueryRepository().get(normalizedQuery);
            normalizedQuery = ds.loadSavedQueryAsNeeded(normalizedQuery, params);
            if (log.isDebugEnabled()) {
                log.debug("Generated query:\n{}\nNormalized query:\n{}", (Object)generatedQuery, (Object)normalizedQuery);
            }
            HttpServerResponse resp = ctx.response();
            ResponseWriter writer = new ResponseWriter(resp, parser.getStreamOptions(), ds.getQueryTimeout(params.getTimeout()));
            long executionStartTime = System.currentTimeMillis();
            if (namedQuery != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found named query: [{}]", (Object)namedQuery);
                }
                if (namedSchema == null) {
                    namedSchema = this.getSchemaRepository().get(namedQuery.getSchema());
                }
                ds.executeQuery(rawSchema, namedQuery, namedSchema != null ? namedSchema.getColumns() : parser.getTable(), params, writer);
            } else {
                TableDefinition queryColumns = namedSchema != null ? namedSchema.getColumns() : parser.getTable();
                ArrayList<ColumnDefinition> additionalColumns = new ArrayList<ColumnDefinition>();
                if (params.showDatasourceColumn()) {
                    additionalColumns.add(new ColumnDefinition("datasource", DataType.Str, true, 0, 0, 0, null, ds.getId(), null));
                }
                if (params.showCustomColumns()) {
                    additionalColumns.addAll(ds.getCustomColumns());
                }
                queryColumns.updateValues(additionalColumns);
                ds.executeQuery(namedSchema == null ? rawSchema : "", parser.getNormalizedQuery(), normalizedQuery, queryColumns, params, writer);
            }
            if (log.isDebugEnabled()) {
                log.debug("Completed execution in {} ms.", (Object)(System.currentTimeMillis() - executionStartTime));
            }
            promise.complete();
        }, false, res -> {
            if (res.succeeded()) {
                if (log.isDebugEnabled()) {
                    log.debug("Wrote back query result");
                }
                ctx.response().end();
            } else {
                ctx.fail(res.cause());
            }
        });
    }

    private void handleWrite(RoutingContext ctx) {
        Repository<NamedDataSource> manager = this.getDataSourceRepository();
        QueryParser parser = QueryParser.fromRequest(ctx, manager, true);
        ctx.response().setChunked(true);
        this.vertx.executeBlocking(promise -> {
            if (log.isTraceEnabled()) {
                log.trace("About to execute mutation...");
            }
            QueryParameters params = parser.getQueryParameters();
            NamedDataSource ds = this.getDataSource(manager, parser.getConnectionString(), params.isDebug());
            params = ds == null ? params : ds.newQueryParameters(params);
            HttpServerResponse resp = ctx.response();
            String generatedQuery = parser.getRawQuery();
            String normalizedQuery = parser.getNormalizedQuery();
            if (log.isDebugEnabled()) {
                log.debug("Generated query:\n{}\nNormalized query:\n{}", (Object)generatedQuery, (Object)normalizedQuery);
            }
            NamedQuery namedQuery = this.getQueryRepository().get(normalizedQuery);
            normalizedQuery = ds.loadSavedQueryAsNeeded(normalizedQuery, params);
            String table = parser.getRawQuery();
            table = namedQuery != null ? parser.extractTable(ds.loadSavedQueryAsNeeded(namedQuery.getQuery(), params)) : parser.extractTable(ds.loadSavedQueryAsNeeded(normalizedQuery, params));
            ds.executeMutation(parser.getRawSchema(), table, parser.getTable(), params, ByteBuffer.wrap(ctx.getBody()));
            resp.write(ByteBuffer.asBuffer(WRITE_RESPONSE));
            promise.complete();
        }, false, res -> {
            if (res.succeeded()) {
                if (log.isDebugEnabled()) {
                    log.debug("Wrote back query result");
                }
                ctx.response().end();
            } else {
                ctx.fail(res.cause());
            }
        });
    }

    private Repository<NamedDataSource> getDataSourceRepository() {
        return this.getRepositoryManager().getRepository(NamedDataSource.class);
    }

    private Repository<NamedSchema> getSchemaRepository() {
        return this.getRepositoryManager().getRepository(NamedSchema.class);
    }

    private Repository<NamedQuery> getQueryRepository() {
        return this.getRepositoryManager().getRepository(NamedQuery.class);
    }

    @Override
    public <T> Extension<T> getExtension(Class<? extends T> clazz) {
        String className = Objects.requireNonNull(clazz).getName();
        Extension<?> ext = null;
        for (Extension<?> e : this.extensions) {
            if (!e.getProviderClass().getName().equals(className)) continue;
            ext = e;
        }
        return ext;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        return this.repos;
    }

    @Override
    public void registerConfigLoader(String configPath, Consumer<JsonObject> consumer) {
        String path = Paths.get(CONFIG_PATH, configPath).toString();
        log.info("Start to monitor configuration file(s) at [{}]", (Object)path);
        ConfigRetriever retriever = ConfigRetriever.create(this.vertx, new ConfigRetrieverOptions().setScanPeriod(this.scanInterval).addStore(new ConfigStoreOptions().setType("directory").setConfig(new JsonObject().put("path", path).put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json").put("format", "json"))))));
        retriever.getConfig(action -> {
            if (action.succeeded()) {
                this.vertx.executeBlocking(promise -> consumer.accept((JsonObject)action.result()), true, res -> {
                    if (!res.succeeded()) {
                        log.error("Failed to load configuration", res.cause());
                    }
                });
            } else {
                log.warn("Not able to load configuration from [{}] due to {}", (Object)path, (Object)action.cause().getMessage());
            }
        });
        retriever.listen(change -> {
            log.info("Configuration change in [{}] detected", (Object)path);
            this.vertx.executeBlocking(promise -> consumer.accept(change.getNewConfiguration()), true, res -> {
                if (!res.succeeded()) {
                    log.error("Failed to reload configuration", res.cause());
                }
            });
        });
    }

    @Override
    public Map<String, Object> getScriptableObjects() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("__vertx", this.vertx);
        vars.put("__datasources", this.getDataSourceRepository());
        vars.put("__schemas", this.getSchemaRepository());
        vars.put("__queries", this.getQueryRepository());
        return vars;
    }

    public static void main(String[] args) {
        startTime = System.currentTimeMillis();
        VertxOptions options = new VertxOptions(Utils.loadJsonFromFile(Paths.get(CONFIG_PATH, Utils.getConfiguration("vertx.json", "VERTX_CONFIG_FILE", "jdbc-bridge.vertx.config.file")).toString()));
        Object metricRegistry = Utils.getDefaultMetricRegistry();
        if (metricRegistry instanceof MeterRegistry) {
            MeterRegistry registry = (MeterRegistry)metricRegistry;
            new ClassLoaderMetrics().bindTo(registry);
            new JvmGcMetrics().bindTo(registry);
            new JvmMemoryMetrics().bindTo(registry);
            new JvmThreadMetrics().bindTo(registry);
            new ProcessorMetrics().bindTo(registry);
            new UptimeMetrics().bindTo(registry);
            options.setMetricsOptions(new MicrometerMetricsOptions().setPrometheusOptions(new VertxPrometheusOptions().setEnabled(true)).setMicrometerRegistry(registry).setEnabled(true));
        }
        Vertx vertx = Vertx.vertx(options);
        vertx.deployVerticle(new JdbcBridgeVerticle());
    }

    static {
        CONFIG_PATH = Utils.getConfiguration("config", "CONFIG_DIR", "jdbc-bridge.config.dir");
    }
}

