/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.util.concurrent.TimeUnit;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Lookup;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.SRVRecord;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.TextParseException;
import ru.yandex.clickhouse.jdbcbridge.internal.github.benmanes.caffeine.cache.Cache;
import ru.yandex.clickhouse.jdbcbridge.internal.github.benmanes.caffeine.cache.Caffeine;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;

public class DnsResolver {
    private static final Logger log = LoggerFactory.getLogger(DnsResolver.class);
    private static final String PREFIX_HOST = "host:";
    private static final String PREFIX_PORT = "port:";
    private final Cache<String, Record[]> dnsCache = Caffeine.newBuilder().maximumSize(100L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public SRVRecord resolve(String srvDns, boolean basedOnWeight) {
        Record[] records = null;
        try {
            records = this.dnsCache.get(srvDns, k -> {
                Record[] results = null;
                try {
                    results = new Lookup(srvDns, 33).run();
                }
                catch (TextParseException textParseException) {
                    // empty catch block
                }
                return results;
            });
        }
        catch (Exception e) {
            log.warn("Not able to resolve given DNS query: [{}]", (Object)srvDns);
        }
        SRVRecord record = null;
        if (records != null) {
            if (basedOnWeight) {
                for (int i = 0; i < records.length; ++i) {
                    SRVRecord rec = (SRVRecord)records[i];
                    if (record != null && record.getWeight() <= rec.getWeight()) continue;
                    record = rec;
                }
            } else {
                record = (SRVRecord)records[0];
            }
        }
        return record;
    }

    public String apply(String dns) {
        boolean onlyHost = false;
        boolean onlyPort = false;
        String query = dns;
        if (dns.startsWith(PREFIX_HOST)) {
            onlyHost = true;
            query = dns.substring(PREFIX_HOST.length());
        } else if (dns.startsWith(PREFIX_PORT)) {
            onlyPort = true;
            query = dns.substring(PREFIX_PORT.length());
        }
        SRVRecord record = this.resolve(query, false);
        if (record != null) {
            dns = onlyHost ? record.getName().canonicalize().toString(true) : (onlyPort ? String.valueOf(record.getPort()) : record.getName().canonicalize().toString(true) + ':' + record.getPort());
        }
        return dns;
    }
}

