/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;

public class ExpandedUrlClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ExpandedUrlClassLoader.class);
    static final String PROTOCOL_FILE = "file";
    static final String FILE_URL_PREFIX = "file:///";
    static final String DRIVER_EXTENSION = ".jar";

    protected static URL[] expandURLs(String ... urls) {
        HashSet<Object> cache = new HashSet<Object>();
        ArrayList<URL> list = new ArrayList<URL>(Objects.requireNonNull(urls).length * 2);
        HashSet<URL> negativeSet = new HashSet<URL>();
        for (String s2 : urls) {
            boolean isNegative;
            if (s2 == null || s2.isEmpty() || cache.contains(s2)) continue;
            boolean bl = isNegative = s2.length() > 1 && s2.charAt(0) == '!';
            if (isNegative) {
                s2 = s2.substring(1);
            }
            URL url = null;
            try {
                url = cache.add(s2) ? new URL(s2) : null;
            }
            catch (MalformedURLException e) {
                try {
                    URL tmp = Paths.get(s2, new String[0]).normalize().toFile().toURI().toURL();
                    s2 = tmp.toString();
                    if (cache.add(s2)) {
                        url = tmp;
                    }
                }
                catch (InvalidPathException exp) {
                    log.warn("Skip invalid path [{}]", (Object)s2);
                }
                catch (MalformedURLException exp) {
                    log.warn("Skip malformed URL [{}]", (Object)s2);
                }
            }
            if (url == null) continue;
            boolean isValid = true;
            if (PROTOCOL_FILE.equals(url.getProtocol())) {
                Path path = null;
                try {
                    path = Paths.get(url.toURI());
                }
                catch (URISyntaxException e) {
                    isValid = false;
                    log.warn("Skip invalid URL [{}]", (Object)url);
                }
                catch (InvalidPathException e) {
                    isValid = false;
                    log.warn("Skip invalid path [{}]", (Object)url);
                }
                if (path != null && Files.isDirectory(path, new LinkOption[0])) {
                    File dir = path.normalize().toFile();
                    Object[] files = dir.list();
                    Arrays.sort(files);
                    for (Object file : files) {
                        if (!((String)file).endsWith(DRIVER_EXTENSION)) continue;
                        file = FILE_URL_PREFIX + dir.getPath() + File.separatorChar + (String)file;
                        if (isNegative) {
                            try {
                                negativeSet.add(new URL((String)file));
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (cache.add(file)) {
                            try {
                                list.add(new URL((String)file));
                            }
                            catch (MalformedURLException e) {
                                log.warn("Skip invalid file [{}]", file);
                            }
                            continue;
                        }
                        log.warn("Discard duplicated file [{}]", file);
                    }
                }
            }
            if (!isValid) continue;
            (isNegative ? negativeSet : list).add(url);
        }
        if (list.removeAll(negativeSet) && log.isDebugEnabled()) {
            log.debug("Excluded URLs: {}", (Object)negativeSet);
        }
        return list.toArray(new URL[list.size()]);
    }

    public ExpandedUrlClassLoader(ClassLoader parent, String ... urls) {
        super(ExpandedUrlClassLoader.expandURLs(urls), parent == null ? ExpandedUrlClassLoader.class.getClassLoader() : parent);
    }
}

