/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.core.ExtensionManager;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;

public final class Extension<T> {
    private static final Logger log = LoggerFactory.getLogger(Extension.class);
    private static final String EXTENSION_NAME = "EXTENSION_NAME";
    private static final String METHOD_INITIALIZE = "initialize";
    private static final String METHOD_NEW_INSTANCE = "newInstance";
    private final String name;
    private final ClassLoader loader;
    private final Class<? extends T> extClass;
    private final Method initMethod;
    private final Method newMethod;

    public Extension(Class<? extends T> clazz) {
        this(null, clazz);
    }

    public Extension(String name, Class<? extends T> clazz) {
        Method m3;
        block9: {
            block8: {
                String extName;
                block7: {
                    this.loader = Thread.currentThread().getContextClassLoader();
                    this.extClass = Objects.requireNonNull(clazz);
                    extName = this.extClass.getSimpleName();
                    try {
                        String declaredName;
                        Field f = this.extClass.getDeclaredField(EXTENSION_NAME);
                        if (f != null && String.class.equals(f.getType()) && (declaredName = (String)f.get(null)) != null) {
                            extName = declaredName;
                        }
                    }
                    catch (Exception e) {
                        if (!log.isTraceEnabled()) break block7;
                        log.trace("Extension [{}] does not have [{}] declared, use [{}] as its name instead", clazz, EXTENSION_NAME, extName);
                    }
                }
                this.name = name == null ? extName : name;
                m3 = null;
                try {
                    m3 = this.extClass.getDeclaredMethod(METHOD_INITIALIZE, ExtensionManager.class);
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block8;
                    log.trace("Extension [{}] does not have static method for initialization.", (Object)clazz);
                }
            }
            this.initMethod = m3;
            try {
                m3 = this.extClass.getDeclaredMethod(METHOD_NEW_INSTANCE, Object[].class);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block9;
                log.trace("Extension [{}] does not have static method for instantiation.", (Object)clazz);
            }
        }
        this.newMethod = m3;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends T> getProviderClass() {
        return this.extClass;
    }

    public Class<?> loadClass(String className) {
        Class<?> clazz = null;
        ClassLoader loader = this.loader == null ? this.getClass().getClassLoader() : this.loader;
        try {
            clazz = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.warn("Not able to load class: " + className);
        }
        catch (Exception e) {
            log.warn("Failed to load class: " + className, e);
        }
        return clazz;
    }

    public void initialize(ExtensionManager manager) {
        if (this.initMethod == null) {
            return;
        }
        try {
            this.initMethod.invoke(null, manager);
        }
        catch (Exception e) {
            if (log.isTraceEnabled() || log.isDebugEnabled()) {
                log.debug("Failed to initialize extension: " + this.extClass, e);
            }
            log.warn("Failed to initialize extension [{}]", (Object)this.extClass);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public T newInstance(Object ... args) {
        current = Thread.currentThread();
        currentLoader = current.getContextClassLoader();
        current.setContextClassLoader(this.loader);
        if (this.newMethod == null) {
            argsLength = args == null ? 0 : args.length;
            matchedConstructor = null;
            for (Constructor<?> c : this.extClass.getDeclaredConstructors()) {
                paramTypes = c.getParameterTypes();
                if (paramTypes.length != argsLength) continue;
                matched = true;
                for (i = 0; i < argsLength; ++i) {
                    clazz = paramTypes[i];
                    arg = args[i];
                    if (clazz.isPrimitive()) {
                        if (!(arg == null || Byte.TYPE.equals(clazz) != false && Byte.class.isInstance(arg) == false || Short.TYPE.equals(clazz) != false && Short.class.isInstance(arg) == false || Integer.TYPE.equals(clazz) != false && Integer.class.isInstance(arg) == false || Long.TYPE.equals(clazz) != false && Long.class.isInstance(arg) == false || Float.TYPE.equals(clazz) != false && Float.class.isInstance(arg) == false || Double.TYPE.equals(clazz) != false && Double.class.isInstance(arg) == false || Boolean.TYPE.equals(clazz) != false && Boolean.class.isInstance(arg) == false) && (!Character.TYPE.equals(clazz) || Character.class.isInstance(arg))) continue;
                        matched = false;
                        break;
                    }
                    if (arg == null || clazz.isInstance(arg)) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                matchedConstructor = c;
                break;
            }
            if (matchedConstructor == null) {
                throw new UnsupportedOperationException("Instantiation not supported for extension: " + this.extClass);
            }
            try {
                var6_9 /* !! */  = matchedConstructor.newInstance(args);
            }
            catch (Exception e) {
                rootCause = e.getCause();
                throw new IllegalArgumentException("Failed to create instance from extension: " + this.extClass, rootCause == null ? e : rootCause);
            }
            return (T)var6_9 /* !! */ ;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 446->464)] { 
lbl-1000:
        // 1 sources

        {
            argsLength = this.newMethod.invoke(null, new Object[]{args});
        }
        return (T)argsLength;
lbl36:
        // 1 sources

        catch (Exception e) {
            rootCause = e.getCause();
            throw new IllegalStateException("Failed to create instance from extension: " + this.extClass, rootCause == null ? e : rootCause);
        }
        finally {
            current.setContextClassLoader(currentLoader);
        }
    }
}

