/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.core.NamedSchema;
import ru.yandex.clickhouse.jdbcbridge.core.QueryParameters;
import ru.yandex.clickhouse.jdbcbridge.core.Repository;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class NamedQuery
extends NamedSchema {
    private static final String CONF_QUERY = "query";
    private static final String CONF_SCHEMA = "schema";
    private static final String CONF_PARAMETERS = "parameters";
    private final String query;
    private final String schema;
    private final QueryParameters parameters;

    public static NamedQuery newInstance(Object ... args) {
        if (Objects.requireNonNull(args).length < 2) {
            throw new IllegalArgumentException("In order to create named query, you need to specify at least ID and repository.");
        }
        String id = (String)args[0];
        Repository manager = (Repository)Objects.requireNonNull(args[1]);
        JsonObject config = args.length > 2 ? (JsonObject)args[2] : null;
        NamedQuery query = new NamedQuery(id, manager, config);
        query.validate();
        return query;
    }

    public NamedQuery(String id, Repository<NamedQuery> repo, JsonObject config) {
        super(id, repo, config);
        String str = config.getString(CONF_QUERY);
        this.query = Objects.requireNonNull(str);
        str = config.getString(CONF_SCHEMA);
        this.schema = str == null ? "" : str;
        this.parameters = new QueryParameters(config.getJsonObject(CONF_PARAMETERS));
    }

    public String getQuery() {
        return this.query;
    }

    public String getSchema() {
        return this.schema;
    }

    public QueryParameters getParameters() {
        return this.parameters;
    }
}

