/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import ru.yandex.clickhouse.jdbcbridge.core.ByteBuffer;
import ru.yandex.clickhouse.jdbcbridge.core.StreamOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerResponse;

public class ResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(ResponseWriter.class);
    private final HttpServerResponse response;
    private final StreamOptions options;
    private final long timeout;
    private final long startTime;

    public ResponseWriter(HttpServerResponse response, StreamOptions options, int timeout) {
        this.response = response;
        this.options = options;
        this.timeout = (long)timeout * 1000L;
        this.startTime = System.currentTimeMillis();
        this.response.setWriteQueueMaxSize(this.options.getMaxBlockSize());
        if (log.isDebugEnabled()) {
            log.debug("Start Time={}, Timeout={}, Max Block Size={}", this.startTime, this.timeout, this.options.getMaxBlockSize());
        }
    }

    public StreamOptions getOptions() {
        return this.options;
    }

    public boolean isOpen() {
        return !this.response.closed() && !this.response.ended();
    }

    public void setDrainHanlder(Handler<Void> handler) {
        this.response.drainHandler((Handler)handler);
    }

    public void write(ByteBuffer buffer) {
        if (this.response.closed() || this.response.ended()) {
            if (buffer != null && buffer.length() > 0) {
                log.warn("Still have at least {} bytes in buffer", (Object)buffer.length());
            }
            throw new IllegalStateException("Response stream was closed");
        }
        if (this.timeout > 0L && System.currentTimeMillis() - this.startTime > this.timeout) {
            throw new IllegalStateException("Abort due to timeout");
        }
        this.response.write(buffer.unwrap());
    }
}

