/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.TimeZone;
import ru.yandex.clickhouse.jdbcbridge.core.ByteBuffer;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class TypedParameter<T> {
    private final Class<T> type;
    private final DataType chType;
    private final String name;
    private final T defaultValue;
    private T value;

    public TypedParameter(Class<T> type, String name, T defaultValue) {
        this(type, null, name, defaultValue, defaultValue);
    }

    public TypedParameter(Class<T> type, DataType chType, String name, T defaultValue) {
        this(type, chType, name, defaultValue, defaultValue);
    }

    public TypedParameter(Class<T> type, String name, T defaultValue, T value) {
        this(type, null, name, defaultValue, value);
    }

    public TypedParameter(Class<T> type, DataType chType, String name, T defaultValue, T value) {
        this.type = Objects.requireNonNull(type);
        if (!type.isPrimitive() && type != BigInteger.class && type != BigDecimal.class && type != Double.class && type != Float.class && type != Long.class && type != Integer.class && type != Short.class && type != Character.class && type != Byte.class && type != Boolean.class && type != String.class) {
            throw new IllegalArgumentException("Only primitive types, string and big decimal are supported!");
        }
        this.name = Objects.requireNonNull(name);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.chType = chType != null ? chType : (defaultValue instanceof BigDecimal ? DataType.Decimal : (defaultValue instanceof Float ? DataType.Float32 : (defaultValue instanceof Double ? DataType.Float64 : (defaultValue instanceof Long ? DataType.UInt64 : (defaultValue instanceof Number ? DataType.Int32 : DataType.Str)))));
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public TypedParameter<T> merge(TypedParameter<T> p) {
        if (p != null) {
            this.value = p.value;
        }
        return this;
    }

    public TypedParameter<T> merge(JsonObject p) {
        return this.merge(p, this.name);
    }

    public TypedParameter<T> merge(JsonObject p, String name) {
        Double innerValue;
        Object newValue;
        String string = name = name == null ? this.name : name;
        if (p != null && (newValue = this.type.isAssignableFrom(BigDecimal.class) ? ((innerValue = p.getDouble(this.name)) == null ? null : BigDecimal.valueOf(innerValue)) : (this.type.isAssignableFrom(Double.class) ? p.getDouble(name) : (this.type.isAssignableFrom(Float.class) ? p.getFloat(name) : (this.type.isAssignableFrom(Long.class) ? p.getLong(name) : (this.type.isAssignableFrom(Boolean.class) ? p.getBoolean(name) : (this.defaultValue instanceof Number ? p.getInteger(name) : p.getString(name))))))) != null) {
            this.value = newValue;
        }
        return this;
    }

    public TypedParameter<T> merge(Object v) {
        return this.merge(v == null ? (String)null : String.valueOf(v));
    }

    public TypedParameter<T> merge(String v) {
        if (v != null) {
            this.value = this.type.isAssignableFrom(BigDecimal.class) ? BigDecimal.valueOf(Double.valueOf(v)) : (this.type.isAssignableFrom(Double.class) ? Double.valueOf(v) : (this.type.isAssignableFrom(Float.class) ? Float.valueOf(v) : (this.type.isAssignableFrom(Long.class) ? Long.valueOf(v) : (this.type.isAssignableFrom(Boolean.class) ? Boolean.valueOf(v) : (this.defaultValue instanceof Number ? Integer.valueOf(v) : v)))));
        }
        return this;
    }

    public TypedParameter<T> writeValueTo(ByteBuffer buffer, int precision, int scale, TimeZone timezone) {
        switch (this.chType) {
            case Bool: 
            case Int8: {
                buffer.writeInt8((Integer)this.value);
                break;
            }
            case Int16: {
                buffer.writeInt16((Integer)this.value);
                break;
            }
            case Int32: {
                buffer.writeInt32((Integer)this.value);
                break;
            }
            case Int64: {
                buffer.writeInt64((Long)this.value);
                break;
            }
            case UInt8: {
                buffer.writeUInt8((Integer)this.value);
                break;
            }
            case Date: 
            case UInt16: {
                buffer.writeUInt16((Integer)this.value);
                break;
            }
            case UInt32: {
                buffer.writeUInt32((Long)this.value);
                break;
            }
            case DateTime: {
                buffer.writeDateTime((Long)this.value, timezone);
                break;
            }
            case DateTime64: {
                buffer.writeDateTime64((Long)this.value, 0, this.chType.getScale(), timezone);
                break;
            }
            case UInt64: {
                buffer.writeUInt64((Long)this.value);
                break;
            }
            case Float32: {
                buffer.writeFloat32(((Float)this.value).floatValue());
                break;
            }
            case Float64: {
                buffer.writeFloat64((Double)this.value);
                break;
            }
            case Decimal: {
                precision = precision <= 0 || precision > 76 ? 10 : precision;
                buffer.writeDecimal((BigDecimal)this.value, precision, scale <= 0 ? 4 : (scale > precision ? precision : scale));
                break;
            }
            case Decimal32: {
                precision = precision <= 0 || precision > 76 ? 9 : precision;
                buffer.writeDecimal32((BigDecimal)this.value, scale <= 0 ? 2 : (scale > precision ? precision : scale));
                break;
            }
            case Decimal64: {
                precision = precision <= 0 || precision > 76 ? 18 : precision;
                buffer.writeDecimal64((BigDecimal)this.value, scale <= 0 ? 4 : (scale > precision ? precision : scale));
                break;
            }
            case Decimal128: {
                precision = precision <= 0 || precision > 76 ? 38 : precision;
                buffer.writeDecimal128((BigDecimal)this.value, scale <= 0 ? 8 : (scale > precision ? precision : scale));
                break;
            }
            case Decimal256: {
                precision = precision <= 0 || precision > 76 ? 76 : precision;
                buffer.writeDecimal256((BigDecimal)this.value, scale <= 0 ? 16 : (scale > precision ? precision : scale));
                break;
            }
            default: {
                buffer.writeString((String)this.value);
            }
        }
        return this;
    }

    public String toKeyValuePairString() {
        return this.name + '=' + this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chType == null ? 0 : this.chType.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedParameter other = (TypedParameter)obj;
        if (this.chType != other.chType) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

