/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import ru.yandex.clickhouse.jdbcbridge.core.ByteBuffer;
import ru.yandex.clickhouse.jdbcbridge.core.ColumnDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.DataAccessException;
import ru.yandex.clickhouse.jdbcbridge.core.DataTableReader;
import ru.yandex.clickhouse.jdbcbridge.core.DataTypeConverter;
import ru.yandex.clickhouse.jdbcbridge.core.DefaultValues;
import ru.yandex.clickhouse.jdbcbridge.core.Extension;
import ru.yandex.clickhouse.jdbcbridge.core.ExtensionManager;
import ru.yandex.clickhouse.jdbcbridge.core.NamedDataSource;
import ru.yandex.clickhouse.jdbcbridge.core.QueryParameters;
import ru.yandex.clickhouse.jdbcbridge.core.Repository;
import ru.yandex.clickhouse.jdbcbridge.core.ResponseWriter;
import ru.yandex.clickhouse.jdbcbridge.core.TableDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;
import ru.yandex.clickhouse.jdbcbridge.impl.JdbcDataSource;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class ScriptDataSource
extends NamedDataSource {
    private static final Logger log = LoggerFactory.getLogger(ScriptDataSource.class);
    private static final Map<String, Object> vars = new HashMap<String, Object>();
    public static final String EXTENSION_NAME = "script";
    public static final String DEFAULT_SCRIPT_EXTENSION = "js";
    public static final String FUNC_INFER_TYPES = "__types__";
    public static final String FUNC_GET_RESULTS = "__results__";
    private final ScriptEngineManager scriptManager;

    public static void initialize(ExtensionManager manager) {
        vars.putAll(manager.getScriptableObjects());
        Extension<ScriptDataSource> thisExtension = manager.getExtension(ScriptDataSource.class);
        manager.getRepositoryManager().getRepository(NamedDataSource.class).registerType(EXTENSION_NAME, thisExtension);
    }

    public static ScriptDataSource newInstance(Object ... args) {
        if (Objects.requireNonNull(args).length < 2) {
            throw new IllegalArgumentException("In order to create JDBC datasource, you need to specify at least ID and datasource manager.");
        }
        String id = (String)args[0];
        Repository manager = (Repository)Objects.requireNonNull(args[1]);
        JsonObject config = args.length > 2 ? (JsonObject)args[2] : null;
        ScriptDataSource ds = new ScriptDataSource(id, manager, config);
        ds.validate();
        return ds;
    }

    protected ScriptDataSource(String id, Repository<NamedDataSource> manager, JsonObject config) {
        super(id, manager, config);
        ClassLoader loader = this.getDriverClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        this.scriptManager = new ScriptEngineManager(loader);
        for (Map.Entry<String, Object> v : vars.entrySet()) {
            this.scriptManager.put(v.getKey(), v.getValue());
        }
    }

    protected ScriptEngine getScriptEngine(String schema, String query) {
        String extName = DEFAULT_SCRIPT_EXTENSION;
        if (schema != null && !schema.isEmpty() && schema.indexOf(32) == -1) {
            extName = schema;
        } else if (query.indexOf(10) == -1 && this.isSavedQuery(query) && Utils.fileExists(query)) {
            extName = query.substring(query.lastIndexOf(46) + 1);
        }
        ScriptEngine engine = this.scriptManager.getEngineByExtension(extName);
        if (engine == null && (engine = this.scriptManager.getEngineByName(extName)) == null) {
            throw new IllegalArgumentException("No script engine available for [" + extName + "]");
        }
        return engine;
    }

    protected TableDefinition guessColumns(ScriptEngine engine, Object result, QueryParameters params) {
        TableDefinition columns;
        block25: {
            columns = TableDefinition.DEFAULT_RESULT_COLUMNS;
            if (log.isDebugEnabled()) {
                log.debug("Got result from script engine: [{}]", (Object)(result == null ? null : result.getClass().getName()));
            }
            if (result == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Trying to infer types by calling function [{}] or reading variable with same name", (Object)FUNC_INFER_TYPES);
                }
                try {
                    try {
                        Invocable i = (Invocable)((Object)engine);
                        columns = TableDefinition.fromObject(i.invokeFunction(FUNC_INFER_TYPES, new Object[0]));
                    }
                    catch (NoSuchMethodException e) {
                        columns = TableDefinition.fromObject(engine.get(FUNC_INFER_TYPES));
                    }
                }
                catch (ScriptException e) {
                    throw new IllegalStateException("Failed to execute given script", e);
                }
            } else {
                if (result instanceof ResultSet) {
                    if (log.isDebugEnabled()) {
                        log.debug("Trying to infer types from JDBC ResultSet");
                    }
                    try (JdbcDataSource jdbc = new JdbcDataSource("jdbc", null, null);){
                        jdbc.getColumnsFromResultSet((ResultSet)result, params);
                        break block25;
                    }
                    catch (SQLException e) {
                        throw new DataAccessException(this.getId(), e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("No clue on types so let's go with default");
                }
                columns = new TableDefinition(new ColumnDefinition("results", this.converter.from(result), true, 0, 0, 0));
            }
        }
        return columns;
    }

    @Override
    protected boolean isSavedQuery(String file) {
        return file != null && file.indexOf(46) > 0;
    }

    @Override
    protected TableDefinition inferTypes(String schema, String originalQuery, String loadedQuery, QueryParameters params) {
        TableDefinition columns = TableDefinition.DEFAULT_RESULT_COLUMNS;
        ScriptEngine engine = this.getScriptEngine(schema, originalQuery);
        try {
            columns = this.guessColumns(engine, engine.eval(loadedQuery), params);
        }
        catch (ScriptException e) {
            throw new DataAccessException(this.getId(), e);
        }
        return columns;
    }

    @Override
    protected void writeQueryResult(String schema, String originalQuery, String loadedQuery, QueryParameters params, ColumnDefinition[] requestColumns, ColumnDefinition[] customColumns, DefaultValues defaultValues, ResponseWriter writer) {
        block21: {
            ScriptEngine engine = this.getScriptEngine(schema, originalQuery);
            try {
                ColumnDefinition[] resultColumns;
                Object result = engine.eval(loadedQuery);
                ColumnDefinition[] columnDefinitionArray = resultColumns = requestColumns.length > 1 && !"results".equals(requestColumns[0].getName()) ? requestColumns : this.guessColumns(engine, result, params).getColumns();
                if (result == null) {
                    try {
                        Invocable i = (Invocable)((Object)engine);
                        result = i.invokeFunction(FUNC_GET_RESULTS, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        result = engine.get(FUNC_GET_RESULTS);
                    }
                }
                if (result instanceof ResultSet) {
                    try (JdbcDataSource jdbc = new JdbcDataSource("jdbc", null, null);){
                        ResultSet rs = (ResultSet)result;
                        JdbcDataSource.ResultSetReader reader = new JdbcDataSource.ResultSetReader(this.getId(), rs, params);
                        reader.process(this.getId(), requestColumns, customColumns, jdbc.getColumnsFromResultSet(rs, params), defaultValues, this.getTimeZone(), params, writer);
                        break block21;
                    }
                    catch (SQLException e) {
                        throw new DataAccessException(this.getId(), e);
                    }
                }
                String[] names = new String[resultColumns.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = resultColumns[i].getName();
                }
                ScriptResultReader reader = new ScriptResultReader(this.converter, result, names);
                reader.process(this.getId(), requestColumns, customColumns, resultColumns, defaultValues, this.getTimeZone(), params, writer);
            }
            catch (ScriptException e) {
                throw new DataAccessException(this.getId(), e);
            }
        }
    }

    @Override
    public void executeMutation(String schema, String table, TableDefinition columns, QueryParameters parameters, ByteBuffer buffer) {
        super.executeMutation(schema, table, columns, parameters, buffer);
    }

    static class ScriptResultReader
    implements DataTableReader {
        private final DataTypeConverter converter;
        private final Object[][] values;
        private int currentRow = 0;

        protected ScriptResultReader(DataTypeConverter converter, Object result, String ... columnNames) {
            this.converter = Objects.requireNonNull(converter);
            this.values = Utils.toObjectArrays(result, columnNames);
        }

        @Override
        public boolean nextRow() {
            return this.currentRow++ < this.values.length;
        }

        @Override
        public boolean isNull(int row, int column, ColumnDefinition metadata) {
            Object[] r = this.values[row];
            return column >= r.length || r[column] == null;
        }

        @Override
        public void read(int row, int column, ColumnDefinition metadata, ByteBuffer buffer) {
            Object v;
            Object[] r = this.values[row];
            Object object = v = column < r.length ? r[column] : null;
            if (v == null) {
                return;
            }
            switch (metadata.getType()) {
                case Bool: 
                case Enum: 
                case Enum8: {
                    try {
                        v = this.converter.as(Integer.class, v);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (v instanceof Integer) {
                        int optionValue = (Integer)v;
                        buffer.writeEnum8(metadata.requireValidOptionValue(optionValue));
                        break;
                    }
                    buffer.writeEnum8(metadata.getOptionValue(String.valueOf(v)));
                    break;
                }
                case Enum16: {
                    try {
                        v = this.converter.as(Integer.class, v);
                    }
                    catch (NumberFormatException optionValue) {
                        // empty catch block
                    }
                    if (v instanceof Integer) {
                        int optionValue = (Integer)v;
                        buffer.writeEnum16(metadata.requireValidOptionValue(optionValue));
                        break;
                    }
                    buffer.writeEnum16(metadata.getOptionValue(String.valueOf(v)));
                    break;
                }
                case Int8: {
                    buffer.writeInt8(this.converter.as(Byte.class, v));
                    break;
                }
                case Int16: {
                    buffer.writeInt16(this.converter.as(Short.class, v));
                    break;
                }
                case Int32: {
                    buffer.writeInt32(this.converter.as(Integer.class, v));
                    break;
                }
                case Int64: {
                    buffer.writeInt64(this.converter.as(Long.class, v));
                    break;
                }
                case Int128: {
                    buffer.writeInt128(this.converter.as(BigInteger.class, v));
                    break;
                }
                case Int256: {
                    buffer.writeInt256(this.converter.as(BigInteger.class, v));
                    break;
                }
                case UInt8: {
                    buffer.writeUInt8(this.converter.as(Integer.class, v));
                    break;
                }
                case UInt16: {
                    buffer.writeUInt16(this.converter.as(Integer.class, v));
                    break;
                }
                case UInt32: {
                    buffer.writeUInt32(this.converter.as(Long.class, v));
                    break;
                }
                case UInt64: {
                    buffer.writeUInt64(this.converter.as(Long.class, v));
                    break;
                }
                case UInt128: {
                    buffer.writeUInt128(this.converter.as(BigInteger.class, v));
                    break;
                }
                case UInt256: {
                    buffer.writeUInt256(this.converter.as(BigInteger.class, v));
                    break;
                }
                case Float32: {
                    buffer.writeFloat32(this.converter.as(Float.class, v).floatValue());
                    break;
                }
                case Float64: {
                    buffer.writeFloat64(this.converter.as(Double.class, v));
                    break;
                }
                case Date: {
                    buffer.writeDate(this.converter.as(Date.class, v));
                    break;
                }
                case DateTime: {
                    buffer.writeDateTime(this.converter.as(Date.class, v), metadata.getTimeZone());
                    break;
                }
                case DateTime64: {
                    buffer.writeDateTime64(this.converter.as(Date.class, v), metadata.getScale(), metadata.getTimeZone());
                    break;
                }
                case Decimal: {
                    buffer.writeDecimal(this.converter.as(BigDecimal.class, v), metadata.getPrecision(), metadata.getScale());
                    break;
                }
                case Decimal32: {
                    buffer.writeDecimal32(this.converter.as(BigDecimal.class, v), metadata.getScale());
                    break;
                }
                case Decimal64: {
                    buffer.writeDecimal64(this.converter.as(BigDecimal.class, v), metadata.getScale());
                    break;
                }
                case Decimal128: {
                    buffer.writeDecimal128(this.converter.as(BigDecimal.class, v), metadata.getScale());
                    break;
                }
                case Decimal256: {
                    buffer.writeDecimal256(this.converter.as(BigDecimal.class, v), metadata.getScale());
                    break;
                }
                default: {
                    buffer.writeString(Utils.toJsonString(v));
                }
            }
        }
    }
}

