/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Address;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Compression;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSInput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSOutput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Tokenizer;

public class AAAARecord
extends Record {
    private byte[] address;

    AAAARecord() {
    }

    public AAAARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 28, dclass, ttl);
        if (Address.familyOf(address) != 1 && Address.familyOf(address) != 2) {
            throw new IllegalArgumentException("invalid IPv4/IPv6 address");
        }
        this.address = address.getAddress();
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.address = in.readByteArray(16);
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.address = st.getAddressBytes(2);
    }

    @Override
    protected String rrToString() {
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(null, this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
        if (addr.getAddress().length == 4) {
            return "::ffff:" + addr.getHostAddress();
        }
        return addr.getHostAddress();
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(this.address);
            }
            return InetAddress.getByAddress(this.name.toString(), this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.address);
    }
}

