/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Address;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Compression;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSInput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSOutput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Tokenizer;

public class ARecord
extends Record {
    private int addr;

    ARecord() {
    }

    private static int fromArray(byte[] array) {
        return (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
    }

    private static byte[] toArray(int addr) {
        byte[] bytes = new byte[]{(byte)(addr >>> 24 & 0xFF), (byte)(addr >>> 16 & 0xFF), (byte)(addr >>> 8 & 0xFF), (byte)(addr & 0xFF)};
        return bytes;
    }

    public ARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 1, dclass, ttl);
        if (Address.familyOf(address) != 1) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.addr = ARecord.fromArray(address.getAddress());
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.addr = ARecord.fromArray(in.readByteArray(4));
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.addr = ARecord.fromArray(st.getAddressBytes(1));
    }

    @Override
    protected String rrToString() {
        return Address.toDottedQuad(ARecord.toArray(this.addr));
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(ARecord.toArray(this.addr));
            }
            return InetAddress.getByAddress(this.name.toString(), ARecord.toArray(this.addr));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU32((long)this.addr & 0xFFFFFFFFL);
    }
}

