/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.io.IOException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Compression;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSInput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSOutput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.TextParseException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Tokenizer;

public class CAARecord
extends Record {
    private int flags;
    private byte[] tag;
    private byte[] value;

    CAARecord() {
    }

    public CAARecord(Name name, int dclass, long ttl, int flags, String tag, String value) {
        super(name, 257, dclass, ttl);
        this.flags = CAARecord.checkU8("flags", flags);
        try {
            this.tag = CAARecord.byteArrayFromString(tag);
            this.value = CAARecord.byteArrayFromString(value);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.flags = in.readU8();
        this.tag = in.readCountedString();
        this.value = in.readByteArray();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.flags = st.getUInt8();
        try {
            this.tag = CAARecord.byteArrayFromString(st.getString());
            this.value = CAARecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.flags);
        sb.append(" ");
        sb.append(CAARecord.byteArrayToString(this.tag, false));
        sb.append(" ");
        sb.append(CAARecord.byteArrayToString(this.value, true));
        return sb.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public String getTag() {
        return CAARecord.byteArrayToString(this.tag, false);
    }

    public String getValue() {
        return CAARecord.byteArrayToString(this.value, false);
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU8(this.flags);
        out.writeCountedString(this.tag);
        out.writeByteArray(this.value);
    }

    public static class Flags {
        public static final int IssuerCritical = 128;

        private Flags() {
        }
    }
}

